<?php
header('Content-Type: application/json');

// ▼▼▼ TU API KEY DE GOOGLE AI VA AQUÍ ▼▼▼
$apiKey = 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'; 

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar nuevos campos
if (!$data || !isset($data['campaign_objective']) || !isset($data['investment']) || !isset($data['messages']) || !isset($data['closed_clients']) || !isset($data['service_price']) || !isset($data['demographics']) || !isset($data['locations']) || !isset($data['platform'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud.']);
    exit;
}

// Cálculos de negocio
$investment = floatval($data['investment']);
$messages = intval($data['messages']);
$closed_clients = intval($data['closed_clients']);
$service_price = floatval($data['service_price']);
$impressions = isset($data['impressions']) && is_numeric($data['impressions']) ? intval($data['impressions']) : 'N/A';
$clicks = isset($data['clicks']) && is_numeric($data['clicks']) ? intval($data['clicks']) : 'N/A';

$cac = ($closed_clients > 0) ? round($investment / $closed_clients, 2) : 0;
$total_revenue = $closed_clients * $service_price;
$roi_percentage = ($investment > 0) ? round((($total_revenue - $investment) / $investment) * 100, 2) : 0;
$conversion_rate = ($messages > 0) ? round(($closed_clients / $messages) * 100, 2) : 0;


// --- PROMPT MAESTRO (v2.2 - ANALISTA ESTRATÉGICO) ---
$prompt = "Actúa como un coach de marketing y consultor de negocios experto. Tu filosofía se basa en el Módulo 5 del curso 'Estrategia Para Atraer Clientes Locales En 3 Pasos', enfocándote en la rentabilidad y el diagnóstico preciso basado en el objetivo de la campaña.

--- FILOSOFÍA DEL CURSO ---
El éxito es la rentabilidad (ROI y CAC). Las métricas como 'Visualizaciones' y 'Clics' son SÍNTOMAS que nos ayudan a diagnosticar problemas en el anuncio, y su importancia depende del objetivo de la campaña.

--- TU TAREA ESPECÍFICA ---
Un estudiante ha proporcionado los datos de su campaña. Analízalos y genera un reporte estratégico y fácil de entender.

--- DATOS COMPLETOS DE LA CAMPAÑA ---
- **Objetivo Principal de la Campaña:** {$data['campaign_objective']}
- Inversión Total: \${$investment}
- Resultados Principales (Mensajes/Leads): {$messages}
- Clientes Cerrados: {$closed_clients}
- Precio del Servicio: \${$service_price}
- Datos de Diagnóstico:
- Visualizaciones (Impresiones): {$impressions}
- Clics en el enlace: {$clicks}
- Datos de Segmentación:
- Segmento Ganador: {$data['demographics']}
- Ubicaciones Ganadoras: {$data['locations']}
- Plataforma Ganadora: {$data['platform']}

--- CÁLCULOS DE NEGOCIO REALIZADOS ---
- Costo De Adquisición De Cliente (CAC): \${$cac}
- Retorno De La Inversión (ROI): {$roi_percentage}%
- Tasa De Cierre (de Lead a Cliente): {$conversion_rate}%

--- FORMATO DE RESPUESTA REQUERIDO ---
Genera un reporte en un objeto JSON válido con la siguiente estructura:
- 'diagnostico_general': Objeto con 'titulo' y 'subtitulo'.
- 'metricas_clave': Objeto con 'cac' ('\${$cac}'), 'roi' ('{$roi_percentage}%'), y 'tasa_cierre' ('{$conversion_rate}%').
- 'analisis_financiero': Un párrafo explicando el CAC y el ROI de esta campaña para el negocio del estudiante.
- 'diagnostico_anuncio': **Un párrafo que analice las métricas de diagnóstico (visualizaciones y clics) EN FUNCIÓN DEL OBJETIVO de la campaña. Por ejemplo, si el objetivo era 'Tráfico' y los clics son bajos, el problema es el anuncio. Si los clics son altos pero no hay ventas, el problema es la página de destino. Si el objetivo era 'Mensajes' y los clics son altos pero los mensajes son bajos, el problema está en la llamada a la acción o la configuración de Messenger.**
- 'plan_de_accion': Un array de 2 o 3 strings con recomendaciones concretas basadas en todo el análisis, especialmente en el diagnóstico del anuncio.";

// --- Llamada a la API de Google ---
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// --- Procesamiento y envío de la respuesta ---
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.']);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'];
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.', 'raw_response' => $generated_text]);
    exit;
}

echo json_encode($final_data);
?>