<?php
header('Content-Type: application/json');

$apiKey = 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'; // TU API KEY

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar todos los nuevos campos
if (!$data || !isset($data['client_name']) || !isset($data['ad_copy']) || !isset($data['ideal_client_summary']) || !isset($data['current_client_message'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud.']);
    exit;
}

// Construir el historial de la conversación para el prompt
$history_string = "";
if (isset($data['conversation_history']) && is_array($data['conversation_history'])) {
    foreach ($data['conversation_history'] as $turn) {
        $role = $turn['role'] === 'user' ? 'Cliente' : 'Vendedor';
        $history_string .= "{$role}: {$turn['text']}\n";
    }
}

// --- PROMPT MAESTRO (v3.0 - COPILOTO CON MEMORIA CONVERSACIONAL) ---
$prompt = "Actúa como un coach de ventas experto y realista para dueños de negocios locales.

--- FILOSOFÍA DE VENTAS ---
La clave es empatizar, entender la necesidad real del cliente, re-enfocar la conversación hacia el VALOR y siempre terminar con una pregunta para seguir conversando.

--- REGLAS Y LÍMITES ESTRICTOS ---
1.  **PROHIBIDO OFRECER DESCUENTOS** o devaluar el servicio.
2.  **PROHIBIDO INVENTAR OFERTAS** (pruebas gratis, 2x1, etc.).
3.  **SER REALISTA Y PROFESIONAL.**

--- TU TAREA ESPECÍFICA ---
Un estudiante está en medio de una conversación y necesita ayuda. Analiza TODO el contexto (el anuncio, el perfil del cliente y el historial completo de la conversación) para proponer las siguientes 2 respuestas estratégicas al ÚLTIMO mensaje del cliente.

--- INFORMACIÓN DE CONTEXTO ---
- **Nombre del Cliente:** {$data['client_name']}
- **Copy del Anuncio que Vio:** \"{$data['ad_copy']}\"
- **Resumen del Perfil del Cliente Ideal:** \"{$data['ideal_client_summary']}\"

--- HISTORIAL DE LA CONVERSACIÓN HASTA AHORA ---
{$history_string}
--- ÚLTIMO MENSAJE DEL CLIENTE (al que debes responder) ---
Cliente: \"{$data['current_client_message']}\"

--- FORMATO DE RESPUESTA REQUERIDO ---
Genera 2 opciones de respuesta. Para CADA una, proporciona:
- **'titulo_estrategia'**: Un nombre claro para la estrategia.
- **'explicacion'**: Por qué esta estrategia funciona en este punto EXACTO de la conversación.
- **'respuesta'**: Un objeto con la respuesta en 'es' (español) y 'en' (inglés), personalizada y terminando en una pregunta.

La respuesta final DEBE ser un objeto JSON válido con una clave 'sugerencias' (un array de 2 objetos).";

$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.']);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'];
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null || !isset($final_data['sugerencias'])) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.', 'raw_response' => $generated_text]);
    exit;
}

echo json_encode($final_data);
?>