<?php
header('Content-Type: application/json');

// ▼▼▼ TU API KEY DE GOOGLE AI VA AQUÍ ▼▼▼
$apiKey = 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'; 

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar los nuevos inputs
if (!$data || !isset($data['business_name']) || !isset($data['ad_copy']) || !isset($data['desire'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud.']);
    exit;
}

// --- PROMPT MAESTRO (v2.2 - CON LÓGICA DE BOTONES CORREGIDA) ---
$prompt = "Actúa como un experto en automatización de marketing para el negocio local '{$data['business_name']}', basándote en la filosofía del curso 'Estrategia Para Atraer Clientes Locales En 3 Pasos'.

--- CONTEXTO Y FILOSOFÍA DEL CURSO (Ejercicio 8) ---
El objetivo es crear una mini-automatización para Messenger. La estructura es: un saludo de bienvenida y 3 preguntas/respuestas rápidas. La clave es mostrar empatía, presentar la solución y CERRAR SIEMPRE CON OTRA PREGUNTA para mantener la conversación.

--- TU TAREA ESPECÍFICA ---
Un estudiante ha proporcionado esta información:
- Nombre del Negocio: {$data['business_name']}
- El Deseo Profundo de su cliente: {$data['desire']}
- El Copy del Anuncio que el cliente vio: \"{$data['ad_copy']}\"

Analiza la información para generar una automatización de Messenger completa. Para CADA PIEZA, proporciona una versión en 'es' (español) y 'en' (inglés).

--- REGLAS ESTRICTAS PARA LA GENERACIÓN ---
1.  **Para los textos de los BOTONES ('pregunta_problema', 'pregunta_solucion', 'pregunta_servicio'):**
    - **OBLIGATORIO:** DEBEN estar escritos desde la PERSPECTIVA DEL CLIENTE, como si él estuviera hablando. No son preguntas que el negocio hace.
    - DEBEN ser cortos y directos (máximo 40 caracteres).
    - Ejemplos correctos: 'Siento que me falta tiempo', '¡Quiero una limpieza profunda!', 'Necesito ayuda con mi jardín', 'Ver los servicios'.
    - Ejemplos incorrectos: '¿Quieres una limpieza profunda?', '¿Te falta tiempo?'.

2.  **Para las RESPUESTAS AUTOMÁTICAS ('respuesta_problema', 'respuesta_solucion', 'respuesta_servicio'):**
    - DEBEN seguir la estructura: Empatía + Solución + Pregunta de Cierre.
    - **OBLIGATORIO:** Siempre deben terminar con una pregunta para mantener la conversación activa.
    - **PROHIBIDO:** No incluir información de contacto (teléfono, web). El objetivo es conversar y calificar al cliente DENTRO de Messenger.
    - La respuesta al botón 'servicio' debe listar los beneficios con checkmarks (✅).

La respuesta DEBE ser un objeto JSON válido con la siguiente estructura anidada:
{
  \"saludo\": {\"es\": \"...\", \"en\": \"...\"},
  \"pregunta_problema\": {\"es\": \"...\", \"en\": \"...\"},
  \"respuesta_problema\": {\"es\": \"...\", \"en\": \"...\"},
  \"pregunta_solucion\": {\"es\": \"...\", \"en\": \"...\"},
  \"respuesta_solucion\": {\"es\": \"...\", \"en\": \"...\"},
  \"pregunta_servicio\": {\"es\": \"...\", \"en\": \"...\"},
  \"respuesta_servicio\": {\"es\": \"...\", \"en\": \"...\"}
}

Usa emojis de forma profesional. Las respuestas deben ser coherentes con la promesa hecha en el copy del anuncio.";

// --- Llamada a la API de Google ---
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// --- Procesamiento y envío de la respuesta ---
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.']);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'];
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.', 'raw_response' => $generated_text]);
    exit;
}

echo json_encode($final_data);
?>