<?php
header('Content-Type: application/json');

// ▼▼▼ TU API KEY DE GOOGLE AI VA AQUÍ ▼▼▼
$apiKey = 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'; 

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!$data || !isset($data['ad_text_es'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Falta texto del anuncio en la solicitud.']);
    exit;
}

// --- PROMPT MAESTRO (v1.2 - LÓGICA MEJORADA) ---
$prompt = "Actúa como un 'localizador de marketing' bilingüe y experto, especializado en traducir anuncios del español al inglés estadounidense para pequeños negocios de servicios.

--- TU MISIÓN ---
Tu objetivo no es una traducción literal. Es adaptar el mensaje para que mantenga su intención persuasiva, tono emocional y claridad, resonando con un público de habla inglesa.

--- TU TAREA ESPECÍFICA ---
Un estudiante ha proporcionado el siguiente texto de un anuncio en español.
Texto Original: \"{$data['ad_text_es']}\"

Analiza el texto y realiza dos cosas:
1.  **Traduce y Adapta:** Crea la versión en inglés del anuncio. Conviértela a un lenguaje natural y efectivo para marketing en EE.UU.
2.  **Explica tus Decisiones:** Proporciona 1 o 2 'notas del traductor' que expliquen las adaptaciones clave que hiciste y por qué. ¡IMPORTANTE! Las 'notas' DEBEN estar escritas 100% en español, ya que son para el estudiante de habla hispana. (Ej: 'La frase X se cambió por Y porque es una expresión más común en inglés...').

--- FORMATO DE RESPUESTA REQUERIDO ---
La respuesta final DEBE ser un objeto JSON válido con la siguiente estructura y claves exactas:
- 'traduccion': El texto completo del anuncio adaptado al inglés.
- 'notas': Un array de 1 o 2 strings, donde cada string es una de tus notas explicativas en español.";

// --- Llamada a la API de Google ---
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// --- Procesamiento y envío de la respuesta ---
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.']);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'];
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null || !isset($final_data['traduccion'])) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.', 'raw_response' => $generated_text]);
    exit;
}

echo json_encode($final_data);
?>