<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Asistente De Respuestas Para Messenger - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { font-family: 'Barlow', sans-serif; }
        #result-container { opacity: 0; transform: scale(0.95); animation: fade-in 0.5s ease-out forwards; }
        @keyframes fade-in { to { opacity: 1; transform: scale(1); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <header class="text-center mb-8">
            <h1 class="text-4xl font-black text-brand-blue-dark">GENERADOR DE RESPUESTAS MESSENGER</h1>
            <p class="text-gray-600 mt-2 text-xl">Automatiza Respuestas Rápidas Y Efectivas Para Tus Anuncios</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="messenger-form" class="space-y-6">
                <div>
                    <label for="business_name" class="block text-lg font-semibold text-brand-blue-dark mb-2">Nombre De Tu Negocio</label>
                    <input type="text" id="business_name" placeholder="Ej: Rod Cleaning Service" class="w-full p-3 border border-gray-300 rounded-md" required>
                </div>
                <div>
                    <label for="ad_copy" class="block text-lg font-semibold text-brand-blue-dark mb-2">Pega El Copy Del Anuncio</label>
                    <textarea id="ad_copy" placeholder="Pega el texto exacto que tu cliente vio en el anuncio de Facebook..." class="w-full p-3 border border-gray-300 rounded-md" rows="4" required></textarea>
                </div>
                <div>
                    <label for="desire" class="block text-lg font-semibold text-brand-blue-dark mb-2">¿Cuál Es El Deseo Profundo Del Cliente?</label>
                    <input type="text" id="desire" placeholder="Ej: Tener paz mental y tiempo libre para la familia" class="w-full p-3 border border-gray-300 rounded-md" required>
                </div>
                
                <button id="generateBtn" type="submit" class="w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center">
                    <span id="btn-text">Generar Automatización de Messenger</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
   
           <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
    
  <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('messenger-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Generando Automatización...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        
        const formData = {
            business_name: document.getElementById('business_name').value,
            ad_copy: document.getElementById('ad_copy').value,
            desire: document.getElementById('desire').value,
        };

        try {
            const response = await fetch('API-Generador-De-Respuestas-Messenger.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || 'Error en el servidor.');
            }

            const data = await response.json();
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            resultContainer.innerHTML = `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudo generar la automatización.</p></div>`;
        } finally {
            btnText.textContent = 'Generar Automatización Messanger';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.style.opacity = '0';
        resultContainer.innerHTML = `
            <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg border-t-4 border-brand-red space-y-8">
                ${createSection('👋 Mensaje De Bienvenida (Saludo Inicial)', 'Este es el primer mensaje que tu cliente recibe automáticamente al hacerle clic al anuncio.', data.saludo.es, data.saludo.en)}
                ${createQASection('🤔 Pregunta Y Respuesta #1 (El Problema)', 'Para el cliente que no tiene tiempo o no sabe cómo empezar.', data.pregunta_problema, data.respuesta_problema)}
                ${createQASection('💡 Pregunta Y Respuesta #2 (La Solución)', 'Para el cliente que quiere saber cómo funciona tu servicio.', data.pregunta_solucion, data.respuesta_solucion)}
                ${createQASection('💰 Pregunta Y Respuesta #3 (El Servicio)', 'Para el cliente interesado que quiere detalles o precios.', data.pregunta_servicio, data.respuesta_servicio)}
            </div>
        `;
        
        document.querySelectorAll('.copy-btn').forEach(button => {
            button.addEventListener('click', function() {
                const textToCopy = unescape(this.dataset.copyText);
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const originalText = this.innerHTML;
                    this.innerHTML = '<i class="fas fa-check"></i> Copiado';
                    setTimeout(() => { this.innerHTML = originalText; }, 2000);
                });
            });
        });

        setTimeout(() => { resultContainer.style.opacity = '1'; }, 100);
    }

    function createSection(title, subtitle, text_es, text_en) {
        return `
            <div class="result-card border-b pb-8">
                <h2 class="text-2xl font-bold text-brand-blue-dark">${title}</h2>
                <p class="text-gray-500 text-sm mt-1">${subtitle}</p>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                    <!-- Español -->
                    <div>
                        <h3 class="font-semibold text-gray-700 mb-2">🇪🇸 Español</h3>
                        <div class="relative">
                            <textarea readonly class="w-full h-28 p-3 bg-gray-100 text-gray-800 rounded-md border-gray-300 resize-none leading-relaxed">${text_es}</textarea>
                            <button class="copy-btn absolute top-3 right-3 bg-brand-red text-white font-bold text-xs py-1 px-2 rounded-md hover:opacity-90" data-copy-text="${escape(text_es)}"><i class="fas fa-copy"></i> Copiar</button>
                        </div>
                    </div>
                    <!-- Inglés -->
                    <div>
                        <h3 class="font-semibold text-gray-700 mb-2">🇺🇸 English</h3>
                        <div class="relative">
                            <textarea readonly class="w-full h-28 p-3 bg-gray-100 text-gray-800 rounded-md border-gray-300 resize-none leading-relaxed">${text_en}</textarea>
                            <button class="copy-btn absolute top-3 right-3 bg-brand-red text-white font-bold text-xs py-1 px-2 rounded-md hover:opacity-90" data-copy-text="${escape(text_en)}"><i class="fas fa-copy"></i> Copiar</button>
                        </div>
                    </div>
                </div>
            </div>`;
    }
    
    function createQASection(title, subtitle, pregunta, respuesta) {
         return `
            <div class="result-card border-b pb-8">
                <h2 class="text-2xl font-bold text-brand-blue-dark">${title}</h2>
                <p class="text-gray-500 text-sm mt-1">${subtitle}</p>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                    <!-- Español -->
                    <div class="space-y-3">
                        <h3 class="font-semibold text-gray-700">🇪🇸 Español</h3>
                        <div>
                           <label class="text-sm font-medium text-gray-600">Texto del Botón (Pregunta)</label>
                           <div class="relative">
                               <input readonly type="text" class="w-full p-2 pr-20 bg-gray-100 rounded-md" value="${pregunta.es}">
                               <button class="copy-btn absolute top-1/2 right-2 -translate-y-1/2 bg-brand-red text-white font-bold text-xs py-1 px-2 rounded-md" data-copy-text="${escape(pregunta.es)}"><i class="fas fa-copy"></i> Copiar</button>
                           </div>
                        </div>
                         <div>
                           <label class="text-sm font-medium text-gray-600">Respuesta Automática</label>
                           <div class="relative">
                               <textarea readonly class="w-full h-32 p-3 bg-gray-100 rounded-md leading-relaxed">${respuesta.es}</textarea>
                               <button class="copy-btn absolute top-3 right-3 bg-brand-red text-white font-bold text-xs py-1 px-2 rounded-md" data-copy-text="${escape(respuesta.es)}"><i class="fas fa-copy"></i> Copiar</button>
                           </div>
                        </div>
                    </div>
                    <!-- Inglés -->
                     <div class="space-y-3">
                        <h3 class="font-semibold text-gray-700">🇺🇸 English</h3>
                        <div>
                           <label class="text-sm font-medium text-gray-600">Button Text (Question)</label>
                           <div class="relative">
                               <input readonly type="text" class="w-full p-2 pr-20 bg-gray-100 rounded-md" value="${pregunta.en}">
                               <button class="copy-btn absolute top-1/2 right-2 -translate-y-1/2 bg-brand-red text-white font-bold text-xs py-1 px-2 rounded-md" data-copy-text="${escape(pregunta.en)}"><i class="fas fa-copy"></i> Copy</button>
                           </div>
                        </div>
                         <div>
                           <label class="text-sm font-medium text-gray-600">Automatic Reply</label>
                           <div class="relative">
                               <textarea readonly class="w-full h-32 p-3 bg-gray-100 rounded-md leading-relaxed">${respuesta.en}</textarea>
                               <button class="copy-btn absolute top-3 right-3 bg-brand-red text-white font-bold text-xs py-1 px-2 rounded-md" data-copy-text="${escape(respuesta.en)}"><i class="fas fa-copy"></i> Copy</button>
                           </div>
                        </div>
                    </div>
                </div>
            </div>`;
    }

    function escape(str) { return str.replace(/"/g, '&quot;').replace(/'/g, '&#39;'); }
    function unescape(str) { return str.replace(/&quot;/g, '"').replace(/&#39;/g, "'"); }
});
</script>
</body>
</html>