<?php
// Inicia la sesión de forma segura, solo si no hay una ya activa.
// Esto evita el error "A session had already been started".
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// --- GUARDIÁN DE CONTENIDO PARA ESTUDIANTES ---
// Si la variable de sesión 'loggedin' no existe o no es verdadera,
// significa que el estudiante no ha iniciado sesión.
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    
    // Lo redirigimos a la página de login principal.
    // Cambia 'index.php' si tu página de login tiene otro nombre.
    header('Location: index.php');
    
    // Detenemos la ejecución del resto del script para que no se muestre el contenido.
    exit;
}

// Si el script llega hasta aquí, significa que el estudiante SÍ ha iniciado sesión
// y el resto del contenido de la página (ej. Modulo01.php) se mostrará.
?>