<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Mini Test De Diagnóstico - Academia De Publicidad</title>
   <?php include 'gtm-header.php'; ?>
   <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { 
            font-family: 'Barlow', sans-serif; 
        }
        #result-container { opacity: 0; transform: scale(0.95); animation: fade-in 0.5s ease-out forwards; }
        @keyframes fade-in { to { opacity: 1; transform: scale(1); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <header class="text-center mb-8">
            <h1 class="text-5xl font-black text-brand-blue-dark">MINI TEST DE DIAGNÓSTICO</h1>
            <p class="text-gray-600 mt-2 text-xl">Un Diagnóstico Rápido Para Descubre Dónde Estás Y Qué Mejorar</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="diagnostic-form">
                <p class="text-center max-w-3xl mx-auto mb-8 text-gray-700 text-lg">Marca todas las opciones que se parezcan a tu situación actual.</p>
                <div class="space-y-8"> <!-- MEJORA: Aumentado el espacio entre opciones -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-8" id="diagnostic-options"> <!-- MEJORA: Aumentado el espacio entre opciones -->
                        <!-- Las opciones se insertarán aquí con JS -->
                    </div>
                     <div class="mt-6">
                        <label for="diag-other" class="font-bold text-brand-blue-dark text-lg">Otro:</label>
                        <input id="diag-other" name="otro" type="text" placeholder="Describe brevemente otra situación..." class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base">
                    </div>
                </div>
                 <button id="generateBtn" type="submit" class="mt-8 w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center">
                    <span id="btn-text">Generar Mi Diagnóstico</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
    
        <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
    
   <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const optionsContainer = document.getElementById('diagnostic-options');
    const diagnosticPoints = [
        { id: 'diag-1', label: 'Dependo Únicamente De Recomendaciones', desc: 'Mis clientes llegan solo si alguien habla de mí. Si no, no tengo nuevos clientes.' },
        { id: 'diag-2', label: 'Publico En Redes, Pero No Veo Resultados', desc: 'Subo contenido, pero nadie comenta ni me contacta. Me siento invisible.' },
        { id: 'diag-3', label: 'He Hecho Anuncios, Pero No Sé Si Funcionan', desc: 'He gastado dinero, pero no entiendo si es una inversión o solo un gasto.' },
        { id: 'diag-4', label: 'No Estoy Haciendo Nada Para Atraer Clientes', desc: 'No tengo una estrategia activa, solo espero que los clientes lleguen solos.' },
        { id: 'diag-5', label: 'Pago A Alguien, Pero No Veo Resultados', desc: 'He contratado ayuda, pero no tengo claridad sobre lo que hacen ni veo más clientes.' },
        { id: 'diag-6', label: 'Veo Videos En YouTube, Pero Me Confundo', desc: 'Busco información, pero todo es confuso, técnico o se contradice.' },
        { id: 'diag-7', label: 'Compro “Leads”, Pero Muchos No Me Contratan', desc: 'Pago por contactos, pero pocos responden o se interesan realmente en mi servicio.' },
        { id: 'diag-8', label: 'Quiero Aprender A Crecer Por Mi Cuenta', desc: 'No quiero depender más de otros para conseguir clientes para mi negocio.' }
    ];

    diagnosticPoints.forEach(point => {
        const div = document.createElement('div');
        div.className = 'flex items-start';
        // MEJORA: Se aumentó el tamaño de la fuente y del checkbox para mayor legibilidad.
        div.innerHTML = `
            <input id="${point.id}" name="${point.label}" type="checkbox" class="h-6 w-6 mt-1 text-brand-red rounded border-gray-400 focus:ring-brand-red flex-shrink-0">
            <div class="ml-4">
                <label for="${point.id}" class="font-bold text-brand-blue-dark text-lg leading-tight cursor-pointer">${point.label}</label>
                <p class="text-gray-600 text-base mt-1">${point.desc}</p>
            </div>`;
        optionsContainer.appendChild(div);
    });

    const form = document.getElementById('diagnostic-form');
    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        const generateBtn = document.getElementById('generateBtn');
        const btnText = document.getElementById('btn-text');
        const loader = document.getElementById('loader');

        btnText.textContent = 'Analizando Tu Situación Actual...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;
        
        const selectedOptions = [];
        form.querySelectorAll('input[type=checkbox]:checked').forEach(checkbox => {
            selectedOptions.push(checkbox.name);
        });

        const otherInput = document.getElementById('diag-other').value;
        if (otherInput) {
            selectedOptions.push(`Otro: ${otherInput}`);
        }

        if (selectedOptions.length === 0) {
            alert('Por favor, selecciona al menos una opción para continuar.');
            btnText.textContent = 'Generar mi Diagnóstico';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
            return;
        }

        try {
            const response = await fetch('API-Mini-Test-De-Diagnostico.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ situations: selectedOptions })
            });

            if (!response.ok) { throw new Error('Error en la respuesta del servidor.'); }
            const data = await response.json();
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            document.getElementById('result-container').innerHTML = `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudo generar el diagnóstico.</p></div>`;
        } finally {
            btnText.textContent = 'Generar mi Diagnóstico';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        const resultContainer = document.getElementById('result-container');
        resultContainer.style.opacity = '0';
        resultContainer.innerHTML = `
            <div class="bg-white p-8 rounded-2xl shadow-lg border-t-8 border-brand-red space-y-8">
                <div class="text-center">
                    <h2 class="text-2xl font-bold text-brand-blue-dark">Tu Puntuación De Preparación</h2>
                    <p class="text-7xl font-bold text-brand-red mt-2">${data.puntuacion}/10</p>
                </div>

                <div class="border-t pt-6">
                    <h3 class="text-2xl font-bold text-brand-blue-dark"><i class="fas fa-search-plus mr-2"></i>Diagnóstico General</h3>
                    <p class="text-gray-700 mt-2 text-lg">${data.diagnostico_general}</p>
                </div>
                
                <div class="border-t pt-6 bg-gray-100 p-6 rounded-lg">
                    <h3 class="text-2xl font-bold text-brand-red"><i class="fas fa-tasks mr-2"></i>Tu Plan De Acción Personalizado</h3>
                    <div class="mt-6 space-y-6">
                        ${data.plan_de_accion.map((step, index) => `
                            <div class="flex items-start">
                                <div class="flex-shrink-0 flex items-center justify-center h-10 w-10 rounded-full bg-brand-red text-white font-bold text-xl">${index + 1}</div>
                                <div class="ml-4">
                                    <p class="text-gray-800 text-lg leading-relaxed">
                                        ${step.replace(/\*\*(.*?)\*\*/g, '<strong class="text-brand-blue-dark">$1</strong>')}
                                    </p>
                                </div>
                            </div>
                        `).join('')}
                    </div>
                </div>
            </div>
        `;
        setTimeout(() => { 
            resultContainer.style.opacity = '1'; 
            resultContainer.scrollIntoView({ behavior: 'smooth' });
        }, 100);
    }
});
</script>
</body>
</html>