<?php
session_start();

// --- CONFIGURACIÓN ---
$dashboard_url = 'AdminDashboard.php'; // Asegúrate de que este es el nombre correcto de tu panel.

// --- REDIRECCIÓN SI YA ESTÁ LOGUEADO ---
if (isset($_SESSION['admin_loggedin']) && $_SESSION['admin_loggedin'] === true) {
    header('Location: ' . $dashboard_url);
    exit;
}

// Incluir la conexión a la base de datos después de la lógica de sesión.
include 'ConectAPI.php';
$error_mensaje = '';

// --- PROCESAMIENTO DEL FORMULARIO DE LOGIN ---
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // *** CORRECCIÓN: Se usa 'email' para que coincida con el sistema ***
    $email_ingresado = $_POST['email'] ?? '';
    $password_ingresada = $_POST['password'] ?? '';

    if (empty($email_ingresado) || empty($password_ingresada)) {
        $error_mensaje = 'Por favor, ingrese email y contraseña.';
    } else {
        // Se usa la tabla 'admins' y se busca por 'email'.
        $stmt = $conn->prepare("SELECT id, password FROM admins WHERE email = ?");
        if ($stmt) {
            $stmt->bind_param("s", $email_ingresado);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows === 1) {
                $admin = $result->fetch_assoc();
                if (password_verify($password_ingresada, $admin['password'])) {
                    // --- ¡ÉXITO! SE GUARDAN LOS DATOS EN LA SESIÓN ---
                    $_SESSION['admin_loggedin'] = true;
                    // Se guarda el ID del admin, que es crucial para las otras funciones.
                    $_SESSION['admin_id'] = $admin['id']; 
                    
                    header('Location: ' . $dashboard_url);
                    exit;
                } else {
                    $error_mensaje = 'El email o la contraseña son incorrectos.';
                }
            } else {
                $error_mensaje = 'El email o la contraseña son incorrectos.';
            }
            $stmt->close();
        } else {
            $error_mensaje = 'Error del servidor. Por favor, intente más tarde.';
        }
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso de Administrador</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style> body { font-family: 'Barlow', sans-serif; } </style>
</head>
<body class="bg-[#07162d]">
    <div class="container mx-auto p-4 flex min-h-screen items-center justify-center">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-0 max-w-5xl rounded-2xl shadow-2xl overflow-hidden">
            <!-- Sección de la imagen con fondo azul -->
            <div class="hidden md:flex bg-[#07162d] items-center justify-center p-8">
                <img src="Portada.jpg" alt="Portada del Producto" class="w-full h-full object-contain">
            </div>
            <!-- Sección del formulario con fondo blanco -->
            <div class="bg-white p-8 md:p-12 flex flex-col justify-center">
                <header class="text-center mb-6">
                    <img src="LogoPlataformaNegro.png" alt="Logo Plataforma" class="mx-auto h-20 w-auto mb-4">
                    <h1 class="text-3xl font-black">
                        <span class="text-[#07162d]">ACCESO</span> <span class="text-[#9e1428]">ADMINISTRADOR</span>
                    </h1>
                    <p class="text-gray-600 mt-2">Ingresa tus credenciales para acceder a las herramientas.</p>
                </header>
                
                <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" class="space-y-6">
                    <!-- *** CORRECCIÓN: Se cambió 'username' por 'email' *** -->
                    <div>
                        <label for="email" class="sr-only">Email</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fas fa-envelope text-gray-400"></i></span>
                            <input type="email" id="email" name="email" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-[#ffc857] focus:border-[#ffc857]" placeholder="Email" required>
                        </div>
                    </div>
                    <!-- Campo de Contraseña -->
                    <div>
                        <label for="password" class="sr-only">Contraseña</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fas fa-key text-gray-400"></i></span>
                            <input type="password" id="password" name="password" class="w-full pl-10 pr-10 py-3 border border-gray-300 rounded-lg focus:ring-[#ffc857] focus:border-[#ffc857]" placeholder="Contraseña" required>
                            <span class="absolute inset-y-0 right-0 flex items-center pr-3 cursor-pointer" id="togglePassword"><i class="fas fa-eye text-gray-400" id="eyeIcon"></i></span>
                        </div>
                    </div>

                    <!-- Mensaje de Error -->
                    <?php if (!empty($error_mensaje)): ?>
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg relative text-center" role="alert"><span><?php echo $error_mensaje; ?></span></div>
                    <?php endif; ?>

                    <button type="submit" class="w-full bg-[#07162d] text-white font-bold py-3 px-8 rounded-lg hover:bg-opacity-90 transition-opacity shadow-lg text-lg">ACCEDER AL PORTAL</button>
                </form>

                <!-- Pie de Página -->
                <?php include 'FooterBK.php'; ?>
            </div>
        </div>
    </div>
    <script>
        const togglePassword = document.querySelector('#togglePassword');
        if (togglePassword) {
            const passwordInput = document.querySelector('#password');
            const eyeIcon = document.querySelector('#eyeIcon');
            togglePassword.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                eyeIcon.classList.toggle('fa-eye');
                eyeIcon.classList.toggle('fa-eye-slash');
            });
        }
    </script>
</body>
</html>
