<?php include 'GuardianKey.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 - Centro de Herramientas IA - Academia De Publicidad</title>
        <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body {
            font-family: 'Barlow', sans-serif;
        }
        .tool-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .tool-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
        }
    </style>
    <script>
        // Configuración de Tailwind CSS con tus colores de marca personalizados
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Barlow', 'sans-serif'],
                    },
                    colors: {
                        'brand-blue-dark': '#07162d',
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<!-- Se cambió el fondo al color de marca 'brand-white' -->
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-6xl relative">

        <!-- Logo -->
        <div class="text-center mb-4">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

   <!-- Barra de bienvenida y salida -->
        <div class="flex flex-row justify-between items-center w-full max-w-lg mx-auto mb-8 px-4">
            <h1 class="text-md md:text-lg font-bold text-brand-blue-dark">
                Bienvenido (a), <span class="text-[var(--color-highlight)]"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
            </h1>
            <a href="index.php?logout=true" class="bg-brand-red text-white font-bold py-2 px-4 rounded-lg hover:opacity-90 transition-opacity inline-flex items-center text-sm flex-shrink-0">
                <i class="fas fa-sign-out-alt mr-2"></i>
                <span>SALIR DEL PORTAL</span>
            </a>
        </div>

        <header class="text-center mb-12">
            <h1 class="text-6xl font-black text-brand-blue-dark">CENTRO DE HERRAMIENTAS INTELIGENTES</h1>
            <p class="text-gray-600 mt-2 text-xl">Tus Asistentes Estratégicos Impulsados Por IA Para Atraer Más Clientes</p>
        </header>

        <!-- Sección Paso 1 -->
        <div class="mb-12">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 max-w-4xl mx-auto">
                <div class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col">
                    <i class="fas fa-clipboard-check text-4xl text-brand-red mx-auto mb-4"></i>
                    <h2 class="text-2xl font-bold text-brand-blue-dark text-center">Mini Test De Diagnóstico</h2>
                    <p class="text-gray-600 text-center mt-2 flex-grow">Evalúa tu situación actual para saber por dónde empezar.</p>
                    <a href="Diagnostico.php" target="_blank" class="mt-6 w-full bg-brand-yellow text-brand-blue-dark font-bold py-2 px-4 rounded-lg hover:opacity-90 text-center">Empezar Aquí</a>
                </div>
                <div class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col">
                    <i class="fas fa-tasks text-4xl text-brand-red mx-auto mb-4"></i>
                    <h2 class="text-2xl font-bold text-brand-blue-dark text-center">Planificador De Objetivos</h2>
                    <p class="text-gray-600 text-center mt-2 flex-grow">Define tus metas y presupuesto para obtener un plan estratégico detallado.</p>
                    <a href="Objetivos.php" target="_blank" class="mt-6 w-full bg-brand-yellow text-brand-blue-dark font-bold py-2 px-4 rounded-lg hover:opacity-90 text-center">Acceder</a>
                </div>
            </div>
        </div>

        <!-- Sección Paso 2 -->
        <div>
            <h2 class="text-3xl font-black text-center text-brand-blue-dark mb-8">TUS ASISTENTES IMPULSADOS CON IA</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col">
                    <i class="fas fa-user-check text-4xl text-brand-red mx-auto mb-4"></i>
                    <h2 class="text-2xl font-bold text-brand-blue-dark text-center">Asistente De Cliente Ideal</h2>
                    <p class="text-gray-600 text-center mt-2 flex-grow">Transforma ideas simples en un perfil estratégico detallado.</p>
                    <a href="Cliente-Ideal.php" target="_blank" class="mt-6 w-full bg-brand-blue-dark text-white font-bold py-2 px-4 rounded-lg hover:bg-opacity-90 text-center">Acceder</a>
                </div>
                <div class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col">
                    <i class="fas fa-bullhorn text-4xl text-brand-red mx-auto mb-4"></i>
                    <h2 class="text-2xl font-bold text-brand-blue-dark text-center">Asistente De Anuncios</h2>
                    <p class="text-gray-600 text-center mt-2 flex-grow">Crea 3 versiones de anuncios basadas en tu perfil de cliente ideal.</p>
                    <a href="Anuncios.php" target="_blank" class="mt-6 w-full bg-brand-blue-dark text-white font-bold py-2 px-4 rounded-lg hover:bg-opacity-90 text-center">Acceder</a>
                </div>
                <div class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col">
                    <i class="fab fa-facebook-messenger text-4xl text-brand-red mx-auto mb-4"></i>
                    <h2 class="text-2xl font-bold text-brand-blue-dark text-center">Asistente De Respuestas</h2>
                    <p class="text-gray-600 text-center mt-2 flex-grow">Genera la mini-automatización de bienvenida para Messenger.</p>
                    <a href="Mensajes-Automatizados.php" target="_blank" class="mt-6 w-full bg-brand-blue-dark text-white font-bold py-2 px-4 rounded-lg hover:bg-opacity-90 text-center">Acceder</a>
                </div>
                <div class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col">
                    <i class="fas fa-language text-4xl text-brand-red mx-auto mb-4"></i>
                    <h2 class="text-2xl font-bold text-brand-blue-dark text-center">Traductor Inteligente</h2>
                    <p class="text-gray-600 text-center mt-2 flex-grow">Adapta tus anuncios del español al inglés con intención de marketing.</p>
                    <a href="Traductor.php" target="_blank" class="mt-6 w-full bg-brand-blue-dark text-white font-bold py-2 px-4 rounded-lg hover:bg-opacity-90 text-center">Acceder</a>
                </div>
                <div class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col">
                    <i class="fas fa-handshake-angle text-4xl text-brand-red mx-auto mb-4"></i>
                    <h2 class="text-2xl font-bold text-brand-blue-dark text-center">Copiloto De Ventas</h2>
                    <p class="text-gray-600 text-center mt-2 flex-grow">Supera objeciones de clientes con respuestas estratégicas.</p>
                    <a href="Copiloto-Ventas.php" target="_blank" class="mt-6 w-full bg-brand-blue-dark text-white font-bold py-2 px-4 rounded-lg hover:bg-opacity-90 text-center">Acceder</a>
                </div>
                <div class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col">
                    <i class="fas fa-chart-line text-4xl text-brand-red mx-auto mb-4"></i>
                    <h2 class="text-2xl font-bold text-brand-blue-dark text-center">Analista De Resultados</h2>
                    <p class="text-gray-600 text-center mt-2 flex-grow">Convierte tus datos de campaña en un plan de acción para mejorar.</p>
                    <a href="Analizador.php" target="_blank" class="mt-6 w-full bg-brand-blue-dark text-white font-bold py-2 px-4 rounded-lg hover:bg-opacity-90 text-center">Acceder</a>
                </div>
            </div>
        </div>
        
        <!-- Sección Recursos Adicionales -->
        <div class="mt-20">
            <h2 class="text-3xl font-black text-center text-brand-blue-dark mb-8">HERRAMIENTAS Y RECURSOS ADICIONALES</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-6 max-w-5xl mx-auto">
                <a href="Instructor.php" class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col items-center text-center">
                    <i class="fas fa-user-tie text-4xl text-brand-red mb-3"></i>
                    <h3 class="text-xl font-bold text-brand-blue-dark">Conoce A Tu Instructor</h3>
                </a>
                <a href="WorkBook.php" class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col items-center text-center">
                    <i class="fas fa-book-open text-4xl text-brand-red mb-3"></i>
                    <h3 class="text-xl font-bold text-brand-blue-dark">Descargar WorkBook</h3>
                </a>
                <a href="CheckList.php" class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col items-center text-center">
                    <i class="fas fa-tasks text-4xl text-brand-red mb-3"></i>
                    <h3 class="text-xl font-bold text-brand-blue-dark">Acceder Al Checklist</h3>
                </a>
                <a href="Plantilla-Anuncios.php" class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col items-center text-center">
                    <i class="fas fa-image text-4xl text-brand-red mb-3"></i>
                    <h3 class="text-xl font-bold text-brand-blue-dark">Plantillas De Anuncios</h3>
                </a>
                <a href="Plantilla-Reels.php" class="tool-card bg-white p-6 rounded-2xl shadow-lg flex flex-col items-center text-center">
                    <i class="fas fa-video text-4xl text-brand-red mb-3"></i>
                    <h3 class="text-xl font-bold text-brand-blue-dark">Plantillas De Reels</h3>
                </a>
            </div>
        </div>

        <!-- Sección de Contacto y Video (REORDENADA) -->
        <div class="mt-20 bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-black text-brand-blue-dark">¿TIENES DUDAS O SUGERENCIAS?</h2>
                <p class="text-gray-600 mt-2">Usa este formulario para enviar tus preguntas. Serán respondidas por email, WhatsApp o en nuestras mentorías mensuales.</p>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-start">
                
                <!-- Video (AHORA PRIMERO) -->
                <div class="mt-8 lg:mt-0">
                    <div class="rounded-lg overflow-hidden shadow-lg aspect-video">
                        <iframe class="w-full h-full" src="https://www.youtube.com/embed/KVjWnn37bTQ?si=2oXUbmrh_q6xYIfV" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    
                            <!-- Aviso Importante (AHORA DE ÚLTIMO) -->
        <div class="max-w-4xl mx-auto bg-white border-l-4 border-brand-yellow p-6 rounded-lg my-12 shadow-md" role="alert">
            <p class="font-bold text-brand-blue-dark text-lg text-center"><i class="fas fa-exclamation-triangle mr-2 text-brand-yellow"></i>AVISO IMPORTANTE</p>
            <p class="text-brand-blue-dark/80 mt-2">Estas herramientas están potencializadas con Inteligencia Artificial para actuar como tu copiloto. Las sugerencias son un excelente punto de partida, pero recuerda que tu juicio y tu conocimiento como estratega son insustituibles. Revisa y adapta siempre los resultados.</p>
        </div>
        
                </div>

                <!-- Formulario (AHORA SEGUNDO) -->
                <div class="bg-brand-blue-dark p-6 md:p-8 rounded-2xl">
                    <form action="config.php" method="POST" class="space-y-6">
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                            <div>
                                <label for="name" class="block font-semibold text-brand-white mb-2">Tu Nombre</label>
                                <input type="text" id="name" name="name" placeholder="Ej: Alejandra" class="w-full p-3 border border-gray-300 rounded-md focus:ring-brand-yellow focus:border-brand-yellow" required>
                            </div>
                            <div>
                                <label for="email" class="block font-semibold text-brand-white mb-2">Email Del Curso</label>
                                <input type="email" id="email" name="email" placeholder="Ej: info@alejandra.com" class="w-full p-3 border border-gray-300 rounded-md focus:ring-brand-yellow focus:border-brand-yellow" required>
                                <p class="text-xs text-gray-300 mt-1">Es importante para verificar que eres estudiante activo.</p>
                            </div>
                        </div>
                        <div>
                            <label for="subject" class="block font-semibold text-brand-white mb-2">Asunto</label>
                            <input type="text" id="subject" placeholder="Ej: Analizar Mis Resultados" name="subject" class="w-full p-3 border border-gray-300 rounded-md focus:ring-brand-yellow focus:border-brand-yellow" required>
                        </div>
                        <div>
                            <label for="question" class="block font-semibold text-brand-white mb-2">Pregunta o Duda Sobre Tus Anuncios o El Curso</label>
                            <textarea id="question" name="question" rows="5" placeholder="Ej: Pueden Analizar Mis Resultados Por Favor" class="w-full p-3 border border-gray-300 rounded-md focus:ring-brand-yellow focus:border-brand-yellow" required></textarea>
                        </div>
                        <button type="submit" class="w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:bg-opacity-90 transition-opacity shadow-lg text-lg">Enviar Mensaje</button>
                    </form>
                </div>

            </div>
        </div>

<br />

   <!-- Barra de bienvenida y salida -->
        <div class="flex flex-row justify-between items-center w-full max-w-lg mx-auto mb-8 px-4">
            <h1 class="text-md md:text-lg font-bold text-brand-blue-dark">
                Bienvenido (a), <span class="text-[var(--color-highlight)]"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
            </h1>
            <a href="index.php?logout=true" class="bg-brand-red text-white font-bold py-2 px-4 rounded-lg hover:opacity-90 transition-opacity inline-flex items-center text-sm flex-shrink-0">
                <i class="fas fa-sign-out-alt mr-2"></i>
                <span>SALIR DEL PORTAL</span>
            </a>
        </div>
        
     <!-- Reemplazo del footer con el include de PHP -->
    <?php include 'FooterBK.php'; ?>
    </div>

</body>
</html>
