<?php include 'files/guardiankey.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit Dashboard | Academia | OrozDesign Multiemdia</title>
    <meta name="description" content="Explora la Academia LocalCRM de OrozDesign: tutoriales paso a paso y recursos para dominar la gestión de prospectos, facturación y agenda">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://unpkg.com"> <link rel="preconnect" href="https://cdnjs.cloudflare.com"> <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer">
    
    <link rel="stylesheet" href="style.css">
</head>
<body data-page-title="BIENVENIDO A LA ACADEMIA"
      data-page-subtitle="APRENDE, CRECE Y DOMINA LA GESTIÓN DE TU NEGOCIO"
      data-page-icon="graduation-cap">

    <div id="toast-container" class="toast-container"></div>
        
<?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-12">
            <section id="academia" class="dashboard-section">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="mb-12">
                        <h4 class="text-2xl font-extrabold text-gray-700 mb-6 uppercase flex items-center gap-3">
                            <i data-lucide="monitor-play" class="w-7 h-7 text-[var(--color-primary)]"></i> Tutoriales de la Plataforma
                        </h4>
                        
                        <div id="videos-container" class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            
                            <div class="video-card flex flex-col gap-3">
                                <div class="w-full aspect-w-16 aspect-h-9 rounded-lg overflow-hidden shadow-xl bg-black relative group">
                                    <video class="w-full h-full object-cover" poster="https://placehold.co/600x337/07162d/ffc857?text=VIDEO+1" preload="none" loading="lazy">
                                        <source src="videos/tutorial_1.mp4" type="video/mp4">
                                        Tu navegador no soporta la etiqueta de video.
                                    </video>
                                    <div class="video-play-trigger absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300 cursor-pointer">
                                        <i data-lucide="play-circle" class="w-16 h-16 text-white"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="font-bold text-md text-gray-800 uppercase">Primeros Pasos en la Plataforma</h5>
                                    <p class="text-sm text-gray-600">Un tour completo por todas las funciones básicas.</p>
                                </div>
                            </div>
                            <div class="video-card flex flex-col gap-3">
                                <div class="w-full aspect-w-16 aspect-h-9 rounded-lg overflow-hidden shadow-xl bg-black relative group">
                                    <video class="w-full h-full object-cover" poster="https://placehold.co/600x337/07162d/ffc857?text=VIDEO+2" preload="none" loading="lazy">
                                        <source src="videos/tutorial_2.mp4" type="video/mp4">
                                        Tu navegador no soporta la etiqueta de video.
                                    </video>
                                    <div class="video-play-trigger absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300 cursor-pointer">
                                        <i data-lucide="play-circle" class="w-16 h-16 text-white"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="font-bold text-md text-gray-800 uppercase">Cómo Gestionar tus Prospectos</h5>
                                    <p class="text-sm text-gray-600">Aprende a organizar y convertir tus potenciales clientes.</p>
                                </div>
                            </div>
                            <div class="video-card flex flex-col gap-3">
                                <div class="w-full aspect-w-16 aspect-h-9 rounded-lg overflow-hidden shadow-xl bg-black relative group">
                                    <video class="w-full h-full object-cover" poster="https://placehold.co/600x337/07162d/ffc857?text=VIDEO+3" preload="none" loading="lazy">
                                        <source src="videos/tutorial_3.mp4" type="video/mp4">
                                        Tu navegador no soporta la etiqueta de video.
                                    </video>
                                    <div class="video-play-trigger absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300 cursor-pointer">
                                        <i data-lucide="play-circle" class="w-16 h-16 text-white"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="font-bold text-md text-gray-800 uppercase">Finanzas: Registra Ingresos y Gastos</h5>
                                    <p class="text-sm text-gray-600">Mantén tus cuentas claras y al día.</p>
                                </div>
                            </div>
                            <div class="video-card flex flex-col gap-3">
                                <div class="w-full aspect-w-16 aspect-h-9 rounded-lg overflow-hidden shadow-xl bg-black relative group">
                                    <video class="w-full h-full object-cover" poster="https://placehold.co/600x337/07162d/ffc857?text=VIDEO+4" preload="none" loading="lazy">
                                        <source src="videos/tutorial_4.mp4" type="video/mp4">
                                        Tu navegador no soporta la etiqueta de video.
                                    </video>
                                    <div class="video-play-trigger absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300 cursor-pointer">
                                        <i data-lucide="play-circle" class="w-16 h-16 text-white"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="font-bold text-md text-gray-800 uppercase">Creando Facturas y Cotizaciones</h5>
                                    <p class="text-sm text-gray-600">Aprende a generar documentos profesionales en segundos.</p>
                                </div>
                            </div>
                            <div class="video-card flex flex-col gap-3 hidden">
                                <div class="w-full aspect-w-16 aspect-h-9 rounded-lg overflow-hidden shadow-xl bg-black relative group">
                                    <video class="w-full h-full object-cover" poster="https://placehold.co/600x337/07162d/ffc857?text=VIDEO+5" preload="none" loading="lazy">
                                        <source src="videos/tutorial_5.mp4" type="video/mp4">
                                        Tu navegador no soporta la etiqueta de video.
                                    </video>
                                    <div class="video-play-trigger absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300 cursor-pointer">
                                        <i data-lucide="play-circle" class="w-16 h-16 text-white"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="font-bold text-md text-gray-800 uppercase">Configurando tu Agenda Online</h5>
                                    <p class="text-sm text-gray-600">Define tus horarios y permite que tus clientes agenden solos.</p>
                                </div>
                            </div>
                            <div class="video-card flex flex-col gap-3 hidden">
                                <div class="w-full aspect-w-16 aspect-h-9 rounded-lg overflow-hidden shadow-xl bg-black relative group">
                                    <video class="w-full h-full object-cover" poster="https://placehold.co/600x337/07162d/ffc857?text=VIDEO+6" preload="none" loading="lazy">
                                        <source src="videos/tutorial_6.mp4" type="video/mp4">
                                        Tu navegador no soporta la etiqueta de video.
                                    </video>
                                    <div class="video-play-trigger absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300 cursor-pointer">
                                        <i data-lucide="play-circle" class="w-16 h-16 text-white"></i>
                                    </div>
                                </div>
                                <div>
                                    <h5 class="font-bold text-md text-gray-800 uppercase">Personalizando tu Página Web</h5>
                                    <p class="text-sm text-gray-600">Ajusta los colores, logo y textos de tu página de ventas.</p>
                                </div>
                            </div>
                        </div>
                        
                        <div id="load-more-container" class="text-center mt-8">
                            <button id="load-more-videos-btn" class="btn-primary font-bold py-3 px-8 rounded-lg uppercase">
                                Cargar Más Tutoriales
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="bg-[var(--color-primary)] p-6 md:p-8 rounded-xl shadow-md mt-12">
                    <h4 class="text-2xl font-extrabold text-white mb-6 uppercase flex items-center gap-3">
                        <i data-lucide="book-open-check" class="w-7 h-7 text-[var(--color-highlight)]"></i> Recursos y Plantillas
                    </h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                        
                        <a href="recurso01.php" target="_blank" rel="noopener noreferrer" class="block bg-white rounded-lg overflow-hidden shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 flex flex-col">
                            <div class="h-40 bg-gray-300">
                                <img src="https://images.unsplash.com/photo-1516534775068-ba3e7458af70?q=80&w=1470&auto=format&fit=crop" alt="Imagen de E-Book" class="w-full h-full object-cover" loading="lazy">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h5 class="font-bold text-lg text-gray-800 mb-2 uppercase">E-Book: Marketing para Principiantes</h5>
                                <p class="text-gray-600 text-sm mb-4 flex-grow">La guía definitiva para empezar a promocionar tu negocio.</p>
                                <div class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg uppercase text-center text-white">Descargar Gratis</div>
                            </div>
                        </a>
                        <a href="recurso02.php" target="_blank" rel="noopener noreferrer" class="block bg-white rounded-lg overflow-hidden shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 flex flex-col">
                            <div class="h-40 bg-gray-300">
                                <img src="https://images.unsplash.com/photo-1556742502-ec7c0e9f34b1?q=80&w=1374&auto=format&fit=crop" alt="Imagen de Plantillas" class="w-full h-full object-cover" loading="lazy">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h5 class="font-bold text-lg text-gray-800 mb-2 uppercase">Plantillas de Cotización</h5>
                                <p class="text-gray-600 text-sm mb-4 flex-grow">Ahorra tiempo con nuestras plantillas listas para usar.</p>
                                <div class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg uppercase text-center text-white">Comprar por $9.99</div>
                            </div>
                        </a>
                        <a href="recurso03.php" target="_blank" rel="noopener noreferrer" class="block bg-white rounded-lg overflow-hidden shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 flex flex-col">
                            <div class="h-40 bg-gray-300">
                                <img src="https://images.unsplash.com/photo-1506784983877-45594efa4c85?q=80&w=1469&auto=format&fit=crop" alt="Imagen de Calendario" class="w-full h-full object-cover" loading="lazy">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h5 class="font-bold text-lg text-gray-800 mb-2 uppercase">Calendario de Contenidos</h5>
                                <p class="text-gray-600 text-sm mb-4 flex-grow">Planifica tus publicaciones en redes sociales para todo el mes.</p>
                                <div class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg uppercase text-center text-white">Descargar Gratis</div>
                            </div>
                        </a>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js" defer></script>
<script src="https://unpkg.com/lucide@latest" defer></script>

<script>
(function() {
    'use strict';
    
    // Función para manejar la reproducción de videos
    function setupVideoPlayTriggers() {
        const videosContainer = document.getElementById('videos-container');
        if (videosContainer) {
            videosContainer.addEventListener('click', function(event) {
                const playTrigger = event.target.closest('.video-play-trigger');
                if (!playTrigger) return;
                
                const videoElement = playTrigger.previousElementSibling;
                if (videoElement && videoElement.tagName === 'VIDEO') {
                    videoElement.play();
                    videoElement.controls = true;
                    playTrigger.style.display = 'none';
                }
            });
        }
    }

    // Función para manejar la carga de más videos
    function setupLoadMoreVideos() {
        const loadMoreBtn = document.getElementById('load-more-videos-btn');
        const videosContainer = document.getElementById('videos-container');
        const loadMoreContainer = document.getElementById('load-more-container');

        if (loadMoreBtn && videosContainer && loadMoreContainer) {
            loadMoreBtn.addEventListener('click', function() {
                const hiddenVideos = videosContainer.querySelectorAll('.video-card.hidden');
                hiddenVideos.forEach(video => {
                    video.classList.remove('hidden');
                    video.classList.add('flex');
                });
                if (loadMoreContainer) {
                    loadMoreContainer.style.display = 'none';
                }
            });
        }
    }

    // Función para manejar el menú lateral (sidebar)
    function setupSidebarToggle() {
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        const mobileMenuButton = document.getElementById('mobile-menu-button');

        const toggleSidebar = () => {
            if (sidebar) sidebar.classList.toggle('-translate-x-full');
            if (sidebarOverlay) sidebarOverlay.classList.toggle('hidden');
        };

        if (mobileMenuButton) {
            mobileMenuButton.addEventListener('click', toggleSidebar);
        }
        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', toggleSidebar);
        }
    }

    // Inicialización al cargar el DOM
    document.addEventListener('DOMContentLoaded', function() {
        // Inicialización del Toast desde URL parámetros (solo aquí, no en header-manager.js)
        const urlParams = new URLSearchParams(window.location.search);
        const notificationType = urlParams.get('notification_type');
        const notificationMessage = urlParams.get('notification_message');

        if (notificationType && notificationMessage) {
            // Se asume que showToast está disponible globalmente o se carga antes.
            // Si no lo está, revisar `files/header-manager.js`.
            if (typeof showToast === 'function') {
                showToast(notificationMessage, notificationType);
            } else {
                console.error("La función showToast no está definida. La notificación Toast podría no mostrarse.");
            }
        }

        // Llamadas a las funciones de configuración
        setupSidebarToggle();
        setupLoadMoreVideos();
        setupVideoPlayTriggers();
    });

})();
</script>
</body>
</html>