<?php
ob_start(); // Iniciar el búfer de salida al inicio del script
session_start();

// ***** IMPORTANTE: ESTAS LÍNEAS ESTÁN AQUÍ PARA DEPURAR. *****
// UNA VEZ QUE FUNCIONE, CÁMBIALAS A: error_reporting(0); ini_set('display_errors', 0);
error_reporting(E_ALL); // Reporta todos los errores - ¡CORREGIDO!
ini_set('display_errors', 1); // Muestra los errores en la pantalla
// *************************************************************

// --- Obtener el mes y año seleccionados para el dashboard (desde URL o por defecto el actual) ---
$selected_dashboard_year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');
$selected_dashboard_month = isset($_GET['month']) ? (int)$_GET['month'] : date('n'); // 'n' para mes sin ceros iniciales (1-12)

// Nombres de los meses en español
$month_names_spanish = [
    1 => "ENERO", 2 => "FEBRERO", 3 => "MARZO", 4 => "ABRIL", 5 => "MAYO", 6 => "JUNIO",
    7 => "JULIO", 8 => "AGOSTO", 9 => "SEPTIEMBRE", 10 => "OCTUBRE", 11 => "NOVIEMBRE", 12 => "DICIEMBRE"
];
$current_report_month_name = $month_names_spanish[$selected_dashboard_month];

// --- DATOS DE ADMINISTRADOR DE EJEMPLO (se mantienen) ---
$admin_data = [
    'nombre' => 'María Admin',
    'email' => 'maria.admin@example.com',
    'foto_perfil' => 'https://placehold.co/100x100/4c7c59/ffffff?text=MA' // Ejemplo de imagen
];

// --- DATOS DUMMY PARA EL DASHBOARD (dependiendo del mes/año seleccionado) ---
// Simulación de datos que cambiarían por mes
switch ("{$selected_dashboard_year}-{$selected_dashboard_month}") {
    case '2024-7': // Julio 2024
        $new_clients_this_week = 7;
        $total_invoicing_this_month = 5500.00;
        $conversion_rate_display = 25.5; // Tasa de conversión de leads (cambiado a float para precisión)
        $customer_satisfaction_display = 95;
        $leads_count = 120; // Nuevos datos
        $prospects_count = 30; // Nuevos datos (personas que ya estás trabajando activamente)
        $help_messages_pending = 3; // Novedad: Mensajes de ayuda pendientes
        break;
    case '2024-6': // Junio 2024
        $new_clients_this_week = 5;
        $total_invoicing_this_month = 4800.00;
        $conversion_rate_display = 22.0;
        $customer_satisfaction_display = 92;
        $leads_count = 100;
        $prospects_count = 25;
        $help_messages_pending = 1;
        break;
    case '2024-5': // Mayo 2024
        $new_clients_this_week = 6;
        $total_invoicing_this_month = 4500.00;
        $conversion_rate_display = 20.0;
        $customer_satisfaction_display = 90;
        $leads_count = 110;
        $prospects_count = 28;
        $help_messages_pending = 0;
        break;
    case '2024-4': // Abril 2024
        $new_clients_this_week = 4;
        $total_invoicing_this_month = 3900.00;
        $conversion_rate_display = 18.0;
        $customer_satisfaction_display = 88;
        $leads_count = 95;
        $prospects_count = 20;
        $help_messages_pending = 0;
        break;
    default: // Datos por defecto si el mes no está simulado
        $new_clients_this_week = 0;
        $total_invoicing_this_month = 0.00;
        $conversion_rate_display = 0.0;
        $customer_satisfaction_display = 0;
        $leads_count = 0;
        $prospects_count = 0;
        $help_messages_pending = 0;
        break;
}

// La meta de facturación ahora se leerá de una sesión/local storage en JS y se usará aquí.
// Por ahora, un valor por defecto o un valor de sesión si se ha guardado.
$invoicing_goal_month = isset($_SESSION['invoicing_goal']) ? (float)$_SESSION['invoicing_goal'] : 7000.00;      

$goal_progress_percentage = ($invoicing_goal_month > 0) ? ($total_invoicing_this_month / $invoicing_goal_month) * 100 : 0;

// Datos para el gráfico de COMPARATIVA DE FACTURACIÓN (Actual vs. Meta)
$invoicing_comparison_chart_labels = ['Facturación Actual', 'Meta Establecida'];
$invoicing_comparison_chart_values = [
    $total_invoicing_this_month,
    $invoicing_goal_month
];

// Datos para el nuevo gráfico de COMPARATIVA DE LEADS VS. PROSPECTOS
$leads_prospects_chart_labels = ['Leads (Entrada)', 'Prospectos (Activos)']; // Etiquetas más claras
$leads_prospects_chart_values = [
    $leads_count,
    $prospects_count
];

// Productos más vendidos (AHORA SOLO LAS 3 VERSIONES DEL CRM)
// Se añaden datos dummy de clientes para cada producto
$top_selling_products_data = [
    [
        'name' => 'CRM Standard', 
        'sales_count' => 25,
        'clients' => [
            ['name' => 'Juan Pérez', 'email' => 'juan.perez@example.com', 'whatsapp' => '50255123456'],
            ['name' => 'María Gómez', 'email' => 'maria.gomez@example.com', 'whatsapp' => '50255654321'],
            ['name' => 'Carlos Ruíz', 'email' => 'carlos.ruiz@example.com', 'whatsapp' => '50255789012'],
            ['name' => 'Luisa Fernández', 'email' => 'luisa.fernandez@example.com', 'whatsapp' => '50255112233'],
            ['name' => 'Roberto Vásquez', 'email' => 'roberto.vasquez@example.com', 'whatsapp' => '50255445566'],
        ]
    ],
    [
        'name' => 'CRM Profesional', 
        'sales_count' => 18,
        'clients' => [
            ['name' => 'Ana Morales', 'email' => 'ana.morales@example.com', 'whatsapp' => '50255234567'],
            ['name' => 'Pedro Solís', 'email' => 'pedro.solis@example.com', 'whatsapp' => '50255876543'],
            ['name' => 'Laura Castillo', 'email' => 'laura.castillo@example.com', 'whatsapp' => '50255998877'],
        ]
    ],
    [
        'name' => 'CRM Avanzada',  
        'sales_count' => 12,
        'clients' => [
            ['name' => 'Sofía Paz', 'email' => 'sofia.paz@example.com', 'whatsapp' => '50255345678'],
            ['name' => 'Diego León', 'email' => 'diego.leon@example.com', 'whatsapp' => '50255987654'],
        ]
    ]
];

// Meses disponibles para el dropdown (simulados)
$available_months_for_dropdown = [];
$current_year_loop = date('Y'); // Usar una variable diferente para el bucle
for ($y = $current_year_loop; $y >= $current_year_loop - 1; $y--) { // Últimos 2 años
    for ($m = 12; $m >= 1; $m--) {
        // Solo meses hasta el actual si es el año actual
        if ($y == $current_year_loop && $m > date('n')) {
            continue;
        }
        $available_months_for_dropdown[] = [
            'year' => $y,
            'month' => $m,
            'label' => $month_names_spanish[$m] . ' ' . $y
        ];
    }
}


// Conversión a JSON para JavaScript
$dashboard_metrics_json = json_encode([
    'new_clients_this_week' => $new_clients_this_week,
    'total_invoicing_this_month' => $total_invoicing_this_month,
    'invoicing_goal_month' => $invoicing_goal_month,
    'goal_progress_percentage' => $goal_progress_percentage,
    'conversion_rate_display' => $conversion_rate_display,
    'customer_satisfaction_display' => $customer_satisfaction_display,
    'leads_count' => $leads_count,
    'prospects_count' => $prospects_count,
    'help_messages_pending' => $help_messages_pending // Añadido
]);

$invoicing_comparison_chart_json = json_encode([
    'labels' => $invoicing_comparison_chart_labels,
    'values' => $invoicing_comparison_chart_values
]);

$leads_prospects_chart_json = json_encode([ // Nuevo JSON para el gráfico
    'labels' => $leads_prospects_chart_labels,
    'values' => $leads_prospects_chart_values
]);

$top_selling_products_json = json_encode($top_selling_products_data);
$available_months_for_dropdown_json = json_encode($available_months_for_dropdown);
$selected_dashboard_month_js = json_encode($selected_dashboard_month);
$selected_dashboard_year_js = json_encode($selected_dashboard_year);


// Manejo de notificaciones de sesión
$notification_message = '';
$notification_type = '';
if (isset($_SESSION['notification'])) {
    $notification_message = $_SESSION['notification']['message'];
    $notification_type = $_SESSION['notification']['type'];
    unset($_SESSION['notification']);
}
ob_end_clean();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit Dashboard | Resumen Ejecutivo</title>
    <meta name="description" content="Dashboard de LocalCRM para monitorear métricas clave del negocio, facturación, progreso de metas y actividad reciente.">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script>
</head>
 
<body data-page-title="PANEL DE ADMINISTRADOR - DASHBOARD"
      data-page-subtitle="RESUMEN EJECUTIVO DEL CRM"
      data-page-icon="layout-dashboard">

<div id="toastNotification" class="toast-notification">
    <i id="toastIcon" class="fas"></i>
    <span id="toastMessage"></span>
    <button id="toastCloseBtn" class="toast-close-btn">×</button>
</div>
<style>
.toast-notification {
    visibility: hidden;
    min-width: 250px;
    background-color: #333;
    color: #fff;
    text-align: center;
    border-radius: 8px;
    padding: 16px;
    position: fixed;
    z-index: 1000;
    left: 50%;
    transform: translateX(-50%);
    bottom: 30px;
    font-size: 17px;
    display: flex;
    align-items: center;
    gap: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    opacity: 0;
    transition: opacity 0.5s, bottom 0.5s;
}

.toast-notification.show {
    visibility: visible;
    opacity: 1;
    bottom: 50px;
}

.toast-notification.success { background-color: #4CAF50; }
.toast-notification.error { background-color: #f44336; }
.toast-notification.info { background-color: #2196F3; }

.toast-notification .toast-close-btn {
    background: none;
    border: none;
    color: white;
    font-size: 20px;
    cursor: pointer;
    margin-left: auto;
}

/* Nuevo: Estilos para el panel lateral derecho */
#rightPanel {
    position: fixed;
    top: 0;
    right: 0;
    width: 100%; /* Por defecto para móviles */
    max-width: 700px; /* Ancho máximo en pantallas grandes - AJUSTADO */
    height: 100%;
    background-color: #ffffff;
    box-shadow: -5px 0 15px rgba(0, 0, 0, 0.1);
    transform: translateX(100%); /* Oculto por defecto a la derecha */
    transition: transform 0.3s ease-out;
    z-index: 60; /* Mayor que el contenido principal pero menor que modals críticos */
    display: flex;
    flex-direction: column;
}

#rightPanel.show {
    transform: translateX(0); /* Muestra el panel */
}

#rightPanelHeader {
    padding: 1.5rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #eee;
    background-color: #f8f8f8;
}

#rightPanelHeader h3 {
    font-size: 1.5rem;
    font-weight: 800;
    color: #333;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

#rightPanelCloseBtn {
    background: none;
    border: none;
    font-size: 2rem;
    cursor: pointer;
    color: #999;
    transition: color 0.2s ease;
}

#rightPanelCloseBtn:hover {
    color: #555;
}

#rightPanelContent {
    flex-grow: 1;
    padding: 1.5rem;
    overflow-y: auto; /* Permite scroll si el contenido es largo */
}

/* Estilos de tabla para el panel lateral */
.client-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 1rem;
}

.client-table th, .client-table td {
    padding: 0.8rem 1rem;
    text-align: left;
    border-bottom: 1px solid #f0f0f0;
}

.client-table th {
    background-color: #f0f0f0;
    font-weight: 700;
    color: #555;
    text-transform: uppercase;
    font-size: 0.85rem;
}

.client-table tbody tr:hover {
    background-color: #f5f5f5;
}

.client-table td {
    color: #444;
    font-size: 0.95rem;
}

/* REMOVIDO: Estilos para enlaces dentro de la tabla si ya no son clickeables
.client-table td a {
    color: var(--color-primary);
    text-decoration: none;
    transition: color 0.2s ease;
}

.client-table td a:hover {
    color: var(--color-highlight);
    text-decoration: underline;
}
*/

.client-table .no-clients-message-row td {
    text-align: center;
    padding: 20px;
    color: #777;
    font-style: italic;
}

/* Overlay para el panel derecho */
#rightPanelOverlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    z-index: 50; /* Un poco más bajo que el panel para que el panel esté encima */
    opacity: 0;
    visibility: hidden;
    transition: opacity 0.3s ease;
}

#rightPanelOverlay.show {
    opacity: 1;
    visibility: visible;
}

</style>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

<?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container" id="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-8">
            <section id="dashboard-core-metrics-section" class="dashboard-section">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="activity" class="w-7 h-7 text-[var(--color-primary)]"></i> RESUMEN DE ACTIVIDAD CLAVE
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">MÉTRICAS IMPORTANTES DEL NEGOCIO.</p>
                        </div>
                        <div class="flex items-center gap-2">
                            <label for="dashboard-month-filter" class="text-gray-700 text-sm font-bold uppercase hidden md:block">Ver Mes:</label>
                            <select id="dashboard-month-filter" class="w-full md:w-48 p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)] bg-white">
                                </select>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-green-500">
                            <i data-lucide="user-plus" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">CLIENTES NUEVOS (SEMANA)</h3>
                                <p id="new-clients-this-week" class="text-5xl font-bold text-green-700">0</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-primary)]">
                            <i data-lucide="dollar-sign" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">FACTURACIÓN TOTAL (MES)</h3>
                                <p id="total-invoicing-this-month" class="text-5xl font-bold text-[var(--color-secondary)]">$0.00</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-purple-500">
                            <i data-lucide="target" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">META DE FACTURACIÓN (MES)</h3>
                                <p id="invoicing-goal-month" class="text-5xl font-bold text-purple-700">$0.00</p>
                            </div>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                            <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-blue-500">
                                <i data-lucide="trending-up" class="w-12 h-12 text-gray-700"></i>
                                <div>
                                    <h3 class="text-lg font-extrabold text-gray-500 mb-1">PROGRESO DE LA META</h3>
                                    <div class="w-full bg-gray-200 rounded-full h-4 relative overflow-hidden">
                                        <div id="goal-progress-bar" class="h-full bg-blue-500 rounded-full" style="width: 0%;"></div>
                                    </div>
                                    <p id="goal-progress-percentage" class="text-3xl font-bold text-blue-700 mt-2">0%</p>
                                </div>
                            </div>
                            <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-highlight)]">
                                <i data-lucide="percent" class="w-12 h-12 text-gray-700"></i>
                                <div>
                                    <h3 class="text-lg font-extrabold text-gray-500 mb-1">TASA DE CONVERSIÓN DE LEADS</h3>
                                    <p id="conversion-rate-month-display" class="text-5xl font-bold text-[var(--color-highlight)]">0%</p>
                                </div>
                            </div>
                            <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-orange-500">
                                <i data-lucide="smile" class="w-12 h-12 text-gray-700"></i>
                                <div>
                                    <h3 class="text-lg font-extrabold text-gray-500 mb-1">REPORTE DEL MES - <span id="report-month-name"></span></h3>
                                    <p id="customer-satisfaction-display" class="text-5xl font-bold text-orange-700">0%</p>
                                </div>
                            </div>
                    </div>

                    <div id="help-messages-alert" class="bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 p-4 rounded-xl shadow-md hidden cursor-pointer" onclick="window.location.href='comunicaciones.php';">
                        <div class="flex items-center gap-3">
                            <i data-lucide="alert-triangle" class="w-8 h-8 flex-shrink-0"></i>
                            <div>
                                <h3 class="text-xl font-bold mb-1 uppercase">¡ATENCIÓN! MENSAJES DE AYUDA PENDIENTES</h3>
                                <p class="text-lg font-semibold"><span id="help-messages-count">0</span> CLIENTES HAN ENVIADO MENSAJES DE AYUDA.</p>
                                <p class="text-sm mt-1">Haz clic aquí para verlos y responder.</p>
                            </div>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mt-8">
                        <div class="bg-white p-6 rounded-xl shadow-md">
                            <h3 class="text-xl font-extrabold text-gray-800 flex items-center gap-2 mb-4">
                                <i data-lucide="trending-up" class="w-6 h-6 text-[var(--color-primary)]"></i> COMPARATIVA DE FACTURACIÓN: ACTUAL VS. META
                            </h3>
                            <div class="relative h-72"><canvas id="invoicingComparisonChart"></canvas></div>
                        </div>

                        <div class="bg-white p-6 rounded-xl shadow-md">
                            <h3 class="text-xl font-extrabold text-gray-800 flex items-center gap-2 mb-4">
                                <i data-lucide="users" class="w-6 h-6 text-[var(--color-secondary)]"></i> COMPARATIVA: LEADS VS. PROSPECTOS
                            </h3>
                            <div class="relative h-72"><canvas id="leadsProspectsChart"></canvas></div>
                        </div>
                    </div>
                </div>
            </section>
            
            <section id="top-selling-products-section" class="dashboard-section mt-8">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="star" class="w-7 h-7 text-[var(--color-primary)]"></i> PRODUCTOS MÁS VENDIDOS
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">UN VISTAZO A TUS VERSIONES DE CRM CON MEJOR RENDIMIENTO.</p>
                        </div>
                    </div>
                    <div id="top-selling-products-list" class="space-y-4">
                        </div>
                </div>
            </section>

        </div>
    </main>
</div>

<div id="confirmDeleteModal" class="fixed inset-0 bg-gray-900 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white p-8 rounded-xl shadow-2xl w-full max-w-sm m-4 transform transition-all duration-300 scale-95 opacity-0 text-center">
        <div class="flex justify-center mb-4">
            <i data-lucide="alert-triangle" class="w-16 h-16 text-red-500"></i>
        </div>
        <h3 class="text-2xl font-bold text-[var(--color-primary)] mb-4 uppercase">CONFIRMAR ACCIÓN</h3>
        <p class="text-gray-700 mb-6 uppercase">¿ESTÁS SEGURO DE QUE DESEAS REALIZAR ESTA ACCIÓN?</p>
        <div class="flex justify-center space-x-4">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closeModal('confirmDeleteModal')">CANCELAR</button>
            <button type="button" class="btn-secondary font-bold py-2 px-4 rounded-lg uppercase" id="confirm-delete-button">CONFIRMAR</button>
        </div>
    </div>
</div>

<div id="rightPanelOverlay" class="hidden" onclick="closeRightPanel()"></div>

<div id="rightPanel" class="hidden">
    <div id="rightPanelHeader">
        <h3 id="panelTitle"><i data-lucide="users" class="w-7 h-7 text-[var(--color-primary)]"></i> Clientes de <span id="productNameInPanel"></span></h3>
        <button id="rightPanelCloseBtn" onclick="closeRightPanel()">&times;</button>
    </div>
    <div id="rightPanelContent">
        <table class="client-table">
            <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Email</th>
                    <th>WhatsApp</th>
                </tr>
            </thead>
            <tbody id="customerTableBody">
                </tbody>
        </table>
    </div>
</div>


<script>
// Variables globales para los datos (dummy)
let dashboardMetrics = (function() {
    try {
        const data = <?php echo $dashboard_metrics_json; ?>;
        return (typeof data === 'object' && data !== null) ? data : {};
    } catch (e) {
        console.error("Error al parsear dashboard_metrics_json:", e);
        return {};
    }
})();

let invoicingComparisonChartData = (function() {
    try {
        const data = <?php echo $invoicing_comparison_chart_json; ?>;
        return (typeof data === 'object' && data !== null) ? data : { labels: [], values: [] };
    } catch (e) {
        console.error("Error al parsear invoicing_comparison_chart_json:", e);
        return { labels: [], values: [] };
    }
})();

let leadsProspectsChartData = (function() {
    try {
        const data = <?php echo $leads_prospects_chart_json; ?>;
        return (typeof data === 'object' && data !== null) ? data : { labels: [], values: [] };
    } catch (e) {
        console.error("Error al parsear leads_prospects_chart_json:", e);
        return { labels: [], values: [] };
    }
})();

let topSellingProductsData = (function() {
    try {
        const data = <?php echo $top_selling_products_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear top_selling_products_json:", e);
        return [];
    }
})();

let availableMonthsForDropdown = (function() {
    try {
        const data = <?php echo $available_months_for_dropdown_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear available_months_for_dropdown_json:", e);
        return [];
    }
})();

// Variable para el mes y año seleccionados (inicializados desde PHP)
let selectedDashboardMonth = (function() {
    try {
        const data = <?php echo $selected_dashboard_month_js; ?>;
        return (typeof data === 'number') ? data : new Date().getMonth() + 1;
    } catch (e) {
        console.error("Error al parsear selected_dashboard_month_js:", e);
        return new Date().getMonth() + 1;
    }
})();

let selectedDashboardYear = (function() {
    try {
        const data = <?php echo $selected_dashboard_year_js; ?>;
        return (typeof data === 'number') ? data : new Date().getFullYear();
    } catch (e) {
        console.error("Error al parsear selected_dashboard_year_js:", e);
        return new Date().getFullYear();
    }
})();

// Variable para la meta de facturación (se inicializa desde PHP/SESSION)
let invoicingGoalMonth = dashboardMetrics.invoicing_goal_month;


document.addEventListener('DOMContentLoaded', function() {
    // --- CONSOLE.LOGS PARA DEPURACIÓN ---
    console.log("--- Depuración de dashboard.php ---");
    console.log("dashboardMetrics:", dashboardMetrics);
    console.log("invoicingComparisonChartData:", invoicingComparisonChartData);
    console.log("leadsProspectsChartData:", leadsProspectsChartData);
    console.log("topSellingProductsData:", topSellingProductsData);
    console.log("availableMonthsForDropdown:", availableMonthsForDropdown);
    console.log("selectedDashboardMonth (initial):", selectedDashboardMonth);
    console.log("selectedDashboardYear (initial):", selectedDashboardYear);
    console.log("invoicingGoalMonth (initial):", invoicingGoalMonth);
    // --- FIN CONSOLE.LOGS PARA DEPURACIÓN ---


    // --- VARIABLES DOM LOCALES ---
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebar-overlay');
    const sidebarCloseBtn = document.getElementById('sidebarCloseBtn');
    
    // Métricas de Resumen
    const newClientsThisWeekElement = document.getElementById('new-clients-this-week');
    const totalInvoicingThisMonthElement = document.getElementById('total-invoicing-this-month');
    const invoicingGoalMonthElement = document.getElementById('invoicing-goal-month');
    const goalProgressBar = document.getElementById('goal-progress-bar');
    const goalProgressPercentageElement = document.getElementById('goal-progress-percentage');
    const conversionRateMonthDisplay = document.getElementById('conversion-rate-month-display');
    const customerSatisfactionDisplay = document.getElementById('customer-satisfaction-display');
    const reportMonthNameDisplay = document.getElementById('report-month-name'); 

    // Nuevo: Elementos de la alerta de mensajes de ayuda
    const helpMessagesAlert = document.getElementById('help-messages-alert');
    const helpMessagesCount = document.getElementById('help-messages-count');

    // Dropdown de mes
    const dashboardMonthFilter = document.getElementById('dashboard-month-filter');

    // Gráficos (obtener los contextos solo si los elementos existen)
    let invoicingComparisonChartCtx;
    let leadsProspectsChartCtx;
    const invoicingComparisonCanvas = document.getElementById('invoicingComparisonChart');
    if (invoicingComparisonCanvas) {
        invoicingComparisonChartCtx = invoicingComparisonCanvas.getContext('2d');
    }
    const leadsProspectsCanvas = document.getElementById('leadsProspectsChart');
    if (leadsProspectsCanvas) {
        leadsProspectsChartCtx = leadsProspectsCanvas.getContext('2d');
    }
    
    // Productos Más Vendidos
    const topSellingProductsList = document.getElementById('top-selling-products-list');

    // Botón general "Añadir Dato" del sidebar (no se usará para añadir datos, es solo un placeholder)
    // Asumo que este ID debería estar en el botón del menú lateral si es relevante para esta página.
    const addDashboardEntryBtn = document.getElementById('addDashboardEntryBtn'); 

    // Modales de confirmación (compartidos)
    const confirmDeleteModal = document.getElementById('confirmDeleteModal');
    const confirmDeleteButton = document.getElementById('confirm-delete-button');
    const confirmModalTitle = document.getElementById('confirmDeleteModal')?.querySelector('h3');
    const confirmModalMessage = document.getElementById('confirmDeleteModal')?.querySelector('p');

    // Elementos del Panel Lateral Derecho
    const rightPanel = document.getElementById('rightPanel');
    const rightPanelOverlay = document.getElementById('rightPanelOverlay');
    const productNameInPanel = document.getElementById('productNameInPanel');
    const customerTableBody = document.getElementById('customerTableBody');


    // Elemento de overlay para los paneles laterales (creado dinámicamente, aunque no se usan paneles de abrir/cerrar en esta página)
    // Este overlay ya no se usa para el panel derecho, se creó uno específico: rightPanelOverlay
    let panelOverlay = document.getElementById('panel-overlay');
    if (!panelOverlay) {
        panelOverlay = document.createElement('div');
        panelOverlay.id = 'panel-overlay';
        panelOverlay.className = 'fixed inset-0 bg-black bg-opacity-50 z-40 hidden';
        document.body.appendChild(panelOverlay);
    }


    // --- FUNCIONES HELPER GLOBALES (reutilizadas) ---

    // Muestra una notificación personalizada (simulada)
    window.showCustomNotification = function(message, type = 'info', duration = 3000) {
        const toast = document.getElementById('toastNotification');
        const toastMessage = document.getElementById('toastMessage');
        const toastIcon = document.getElementById('toastIcon');
        const toastCloseBtn = document.getElementById('toastCloseBtn');
        let toastTimeout;

        if (!toast || !toastMessage || !toastIcon || !toastCloseBtn) {
            console.warn(`[NOTIFICACION - FALLBACK] Elementos de toast no encontrados. Mensaje: ${type.toUpperCase()}: ${message}`);
            return;
        }

        clearTimeout(toastTimeout);
        toast.className = 'toast-notification'; // Resetear clases
        toastIcon.className = 'fas'; // Resetear icono base

        toastMessage.textContent = message;
        toast.classList.add(type === 'success' ? 'success' : (type === 'error' ? 'error' : 'info'));
        
        if (type === 'success') {
            toastIcon.classList.add('fa-check-circle');
        } else if (type === 'error') {
            toastIcon.classList.add('fa-exclamation-circle');
        } else {
            toastIcon.classList.add('fa-info-circle');
        }

        toast.classList.add('show');
        toastTimeout = setTimeout(() => {
            toast.classList.remove('show');
        }, duration);

        toastCloseBtn.onclick = () => {
            clearTimeout(toastTimeout);
            toast.classList.remove('show');
        };

        console.log(`[NOTIFICACION - ${type.toUpperCase()}] ${message}`);
    };

    // Abre/cierra modales (se mantiene solo para confirmDeleteModal)
    window.openModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (!modal) { console.error(`Error: Modal con ID "${modalId}" no encontrado.`); return; }
        const modalBox = modal.querySelector('div:first-of-type');
        modal.classList.remove('hidden');
        setTimeout(() => { 
            if (modalBox) modalBox.classList.remove('scale-95', 'opacity-0'); 
        }, 50);
        console.log(`[dashboard.php] Modal ${modalId} abierto.`);
        lucide.createIcons({ container: modal }); // Asegura que los íconos del modal se muestren
    };

    window.closeModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (!modal) { console.error(`Error: Modal con ID "${modalId}" no encontrado para cerrar.`); return; }
        const modalBox = modal.querySelector('div:first-of-type');
        if (modalBox) modalBox.classList.add('scale-95', 'opacity-0');
        setTimeout(() => { modal.classList.add('hidden'); }, 300);
        console.log(`[dashboard.php] Modal ${modalId} cerrado.`);
    };
    
    // Función de confirmación general (adaptada para este contexto)
    window.openConfirmActionModal = function(actionCallback, title = 'CONFIRMAR ACCIÓN', message = '¿ESTÁS SEGURO DE QUE DESEAS REALIZAR ESTA ACCIÓN?') {
        if (!confirmDeleteButton || !confirmModalTitle || !confirmModalMessage) { showCustomNotification("Error: Elementos del modal de confirmación no encontrados.", 'error'); return; }
        
        confirmModalTitle.textContent = title; 
        confirmModalMessage.textContent = message;
        confirmDeleteButton.onclick = () => { // Asigna el callback al botón de confirmar
            actionCallback();
            closeModal('confirmDeleteModal');
        };
        openModal('confirmDeleteModal'); // Abre el modal
    };


    // Descarga datos como CSV (adaptada para rendimiento)
    function descargarComoCSV(dataArray, filename) {
        if (!Array.isArray(dataArray) || dataArray.length === 0) { showCustomNotification('No hay datos para descargar.', 'info'); return; }
        const escapeCSV = (value) => {
            if (value === null || value === undefined) { return ''; }
            value = String(value);
            if (value.search(/("|,|\n)/g) >= 0) { return `"${value.replace(/"/g, '""')}"`; }
            return value;
        };
        
        let headers = [];
        // Determinar encabezados dinámicamente si no se especifican para cada tabla
        if (dataArray.length > 0) {
            headers = Object.keys(dataArray[0]);
        } else {
            showCustomNotification('No se pudieron determinar los encabezados del CSV.', 'error');
            return;
        }
        
        const csvRows = [headers.map(h => escapeCSV(h.replace(/_/g, ' ').toUpperCase())).join(',')];
        dataArray.forEach(item => {
            const values = headers.map(header => escapeCSV(item[header]));
            csvRows.push(values.join(','));
        });
        const csvContent = csvRows.join('\n');
        const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
        const link = document.createElement('a');
        if (link.download !== undefined) {
            const url = URL.createObjectURL(blob);
            link.setAttribute('href', url); link.setAttribute('download', filename);
            link.style.visibility = 'hidden'; document.body.appendChild(link);
            link.click(); document.body.removeChild(link);
            showCustomNotification('CSV generado y descargado.', 'success');
        } else {
            showCustomNotification('Tu navegador no soporta la descarga directa de archivos.', 'error');
        }
    }


    // --- FUNCIONES ESPECÍFICAS DEL DASHBOARD ---

    // Actualiza las tarjetas de métricas de resumen en la parte superior
    function updateDashboardMetricsDisplay() {
        if (newClientsThisWeekElement) newClientsThisWeekElement.textContent = dashboardMetrics.new_clients_this_week.toString();
        if (totalInvoicingThisMonthElement) totalInvoicingThisMonthElement.textContent = `$${dashboardMetrics.total_invoicing_this_month.toFixed(2)}`;
        if (invoicingGoalMonthElement) invoicingGoalMonthElement.textContent = `$${dashboardMetrics.invoicing_goal_month.toFixed(2)}`;
        
        // Progreso de la meta
        const progress = Math.min(100, Math.max(0, dashboardMetrics.goal_progress_percentage)); // Asegura que esté entre 0 y 100
        if (goalProgressBar) goalProgressBar.style.width = `${progress}%`;
        if (goalProgressPercentageElement) goalProgressPercentageElement.textContent = `${progress.toFixed(1)}%`;

        // Métricas adicionales
        if (conversionRateMonthDisplay) conversionRateMonthDisplay.textContent = `${dashboardMetrics.conversion_rate_display.toFixed(1)}%`;
        if (customerSatisfactionDisplay) customerSatisfactionDisplay.textContent = `${dashboardMetrics.customer_satisfaction_display}%`;
        
        // Nombre del mes para el reporte
        if (reportMonthNameDisplay) {
             const monthNames = ["ENERO", "FEBRERO", "MARZO", "ABRIL", "MAYO", "JUNIO",
                                 "JULIO", "AGOSTO", "SEPTIEMBRE", "OCTUBRE", "NOVIEMBRE", "DICIEMBRE"];
            reportMonthNameDisplay.textContent = monthNames[selectedDashboardMonth - 1] || 'N/A';
        }

        // Novedad: Alerta de mensajes de ayuda pendientes
        if (helpMessagesAlert && helpMessagesCount) {
            if (dashboardMetrics.help_messages_pending > 0) {
                helpMessagesCount.textContent = dashboardMetrics.help_messages_pending;
                helpMessagesAlert.classList.remove('hidden'); // Muestra la alerta
            } else {
                helpMessagesAlert.classList.add('hidden'); // Oculta la alerta si no hay mensajes
            }
        }
    }

    // Llena el selector de filtro de mes/año con las opciones disponibles
    function populateDashboardMonthFilter() {
        if (!dashboardMonthFilter) return;

        dashboardMonthFilter.innerHTML = ''; // Limpiar opciones existentes

        availableMonthsForDropdown.forEach(period => {
            const option = document.createElement('option');
            // Formato YYYY-MM para el valor, p.ej., "2024-07"
            option.value = `${period.year}-${String(period.month).padStart(2, '0')}`; 
            option.textContent = period.label.toUpperCase();
            // Seleccionar la opción si coincide con el período de filtro actual
            if (period.year === selectedDashboardYear && period.month === selectedDashboardMonth) {
                option.selected = true;
            }
            dashboardMonthFilter.appendChild(option);
        });
    }

    // Renderiza el gráfico de COMPARATIVA DE FACTURACIÓN (Actual vs. Meta)
    let invoicingChartInstance = null; // Mantener una referencia para destruir/actualizar
    function renderInvoicingComparisonChart() {
        if (!invoicingComparisonChartCtx) {
            console.error('Contexto del canvas de comparación de facturación no encontrado.');
            return;
        }

        if (invoicingChartInstance) { // Si el gráfico ya existe, destrúyelo para volver a crearlo
            invoicingChartInstance.destroy();
        }

        invoicingChartInstance = new Chart(invoicingComparisonChartCtx, { // Guarda la instancia
            type: 'bar', // Gráfico de barras para comparar
            data: {
                labels: invoicingComparisonChartData.labels,
                datasets: [{
                    label: 'Monto ($)',
                    data: invoicingComparisonChartData.values,
                    backgroundColor: [
                        'var(--color-primary)',    // Color para Facturación Actual
                        'var(--color-highlight)'  // Color para Meta Establecida
                    ],
                    borderColor: [
                        'var(--color-primary)',
                        'var(--color-highlight)'
                    ],
                    borderWidth: 1,
                    borderRadius: 5
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Monto ($)'
                        },
                        ticks: {
                            callback: function(value) {
                                return '$' + value.toLocaleString(); // Formato de moneda
                            }
                        }
                    }
                },
                plugins: {
                    legend: { display: false },
                    tooltip: { // Mejora los tooltips
                        callbacks: {
                            label: function(context) {
                                let label = context.dataset.label || '';
                                if (label) {
                                    label += ': ';
                                }
                                if (context.parsed.y !== null) {
                                    label += new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD' }).format(context.parsed.y);
                                }
                                return label;
                            }
                        }
                    }
                }
            }
        });
    }

    // Nueva función para renderizar el gráfico de Leads vs. Prospectos
    let leadsProspectsChartInstance = null; // Mantener una referencia para destruir/actualizar
    function renderleadsProspectsChart() {
        if (!leadsProspectsChartCtx) {
            console.error('Contexto del canvas de Leads vs. Prospectos no encontrado.');
            return;
        }

        if (leadsProspectsChartInstance) { // Si el gráfico ya existe, destrúyelo
            leadsProspectsChartInstance.destroy();
        }

        leadsProspectsChartInstance = new Chart(leadsProspectsChartCtx, {
            type: 'bar',
            data: {
                labels: leadsProspectsChartData.labels,
                datasets: [{
                    label: 'Cantidad',
                    data: leadsProspectsChartData.values,
                    backgroundColor: [
                        'rgba(75, 192, 192, 0.6)', // Color para Leads (verde azulado)
                        'rgba(153, 102, 255, 0.6)' // Color para Prospectos (morado)
                    ],
                    borderColor: [
                        'rgba(75, 192, 192, 1)',
                        'rgba(153, 102, 255, 1)'
                    ],
                    borderWidth: 1,
                    borderRadius: 5
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Cantidad'
                        },
                        ticks: {
                            precision: 0 // Asegura que los ticks sean números enteros
                        }
                    }
                },
                plugins: {
                    legend: { display: false }
                }
            }
        });
    }

    // Función: Muestra los detalles del cliente en el PANEL LATERAL DERECHO
    window.showCustomerDetailsInPanel = function(product) {
        if (!productNameInPanel || !customerTableBody || !rightPanel || !rightPanelOverlay) return;

        productNameInPanel.textContent = product.name;
        customerTableBody.innerHTML = ''; // Limpiar filas existentes

        if (product.clients && product.clients.length > 0) {
            product.clients.forEach(client => {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${client.name}</td>
                    <td>${client.email}</td>
                    <td>${client.whatsapp}</td>
                `;
                customerTableBody.appendChild(row);
            });
        } else {
            const noClientsRow = document.createElement('tr');
            noClientsRow.className = 'no-clients-message-row';
            noClientsRow.innerHTML = `<td colspan="3">No hay clientes registrados para esta versión de CRM en este período.</td>`;
            customerTableBody.appendChild(noClientsRow);
        }
        
        rightPanel.classList.add('show');
        rightPanel.classList.remove('hidden'); // Asegura que la clase hidden se quite para la transición
        rightPanelOverlay.classList.add('show');
        rightPanelOverlay.classList.remove('hidden'); // Muestra el overlay

        // Renderizar iconos de Lucide dentro del panel (aunque no haya en esta sección, es buena práctica)
        lucide.createIcons({ container: rightPanel });
    };

    // Función: Cierra el panel lateral derecho
    window.closeRightPanel = function() {
        if (rightPanel && rightPanelOverlay) {
            rightPanel.classList.remove('show');
            rightPanelOverlay.classList.remove('show');
            // Añadir 'hidden' después de la transición para asegurar que no interfiera
            setTimeout(() => {
                rightPanel.classList.add('hidden');
                rightPanelOverlay.classList.add('hidden');
            }, 300); // Coincide con la duración de la transición CSS
        }
    };

    // Renderiza la lista de Productos Más Vendidos (versiones de CRM)
    function renderTopSellingProducts() {
        if (!topSellingProductsList) return;
        topSellingProductsList.innerHTML = ''; // Limpiar lista

        if (topSellingProductsData.length === 0) {
            topSellingProductsList.innerHTML = `<p class="text-gray-500 uppercase text-center py-4">No hay versiones de CRM para mostrar en este momento.</p>`;
        } else {
            topSellingProductsData.forEach(product => {
                const item = document.createElement('div');
                item.className = 'bg-gradient-to-br from-white to-gray-50 p-5 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 flex justify-between items-center border border-gray-100 cursor-pointer';
                item.innerHTML = `
                    <div class="flex items-center">
                        <i data-lucide="package" class="w-8 h-8 text-[var(--color-primary)] mr-4 flex-shrink-0"></i>
                        <span class="font-extrabold text-xl text-gray-800 uppercase">${product.name}</span>
                    </div>
                    <span class="text-2xl font-bold text-[var(--color-secondary)]">${product.sales_count} ventas</span>
                `;
                
                // Añadir el event listener para abrir el panel lateral de clientes
                item.addEventListener('click', () => {
                    showCustomerDetailsInPanel(product);
                });

                topSellingProductsList.appendChild(item);
            });
            // Asegurarse de que los nuevos iconos de Lucide se rendericen después de añadir los elementos
            lucide.createIcons({ container: topSellingProductsList });
        }
    }


    // --- INICIALIZACIÓN DE LA PÁGINA ---

    // Mostrar notificación PHP si existe
    const phpNotificationMessage = "<?php echo addslashes($notification_message); ?>";
    const phpNotificationType = "<?php echo addslashes($notification_type); ?>";
    if (phpNotificationMessage) {
        showCustomNotification(phpNotificationMessage, phpNotificationType);
    }

    // Eventos de la barra lateral (menú móvil)
    // Se asume que toggleSidebar está en header-manager.js, pero se añade un fallback.
    const mobileMenuButtonHeader = document.getElementById('mobile-menu-button'); 
    const sidebarCloseBtnHeader = document.getElementById('sidebarCloseBtn'); 
    
    // Define `toggleSidebar` si no existe en `header-manager.js` (para evitar errores si no está cargada)
    if (typeof window.toggleSidebar === 'undefined') {
        window.toggleSidebar = function() {
            const sidebarElement = document.getElementById('sidebar');
            const sidebarOverlayElement = document.getElementById('sidebar-overlay');
            if (sidebarElement && sidebarOverlayElement) {
                sidebarElement.classList.toggle('-translate-x-full');
                sidebarOverlayElement.classList.toggle('hidden');
            }
        };
    }

    if (mobileMenuButtonHeader) mobileMenuButtonHeader.addEventListener('click', window.toggleSidebar);
    if (sidebarOverlay) sidebarOverlay.addEventListener('click', window.toggleSidebar);
    if (sidebarCloseBtnHeader) sidebarCloseBtnHeader.addEventListener('click', window.toggleSidebar);


    // 1. Actualizar métricas de resumen al cargar
    updateDashboardMetricsDisplay();

    // 2. Poblar dropdown de meses
    populateDashboardMonthFilter();

    // 3. Renderizar gráficos
    renderInvoicingComparisonChart();
    renderleadsProspectsChart();
    
    // 4. Renderizar lista de Productos Más Vendidos (ahora versiones de CRM)
    renderTopSellingProducts();

    // 5. Listener para el dropdown de selección de mes
    if (dashboardMonthFilter) {
        dashboardMonthFilter.addEventListener('change', function() {
            const [year, month] = this.value.split('-').map(Number);
            // Simular recarga de página para nuevos datos del mes
            // En un sistema real, harías una una llamada AJAX para obtener los nuevos datos
            // sin recargar la página completa.
            window.location.href = `dashboard.php?year=${year}&month=${month}`;
        });
    }

    // 6. Listener para el botón "Añadir Dato" del sidebar (en esta página es un placeholder)
    const addDashboardEntryBtnElement = document.getElementById('addDashboardEntryBtn');
    if (addDashboardEntryBtnElement) {
        addDashboardEntryBtnElement.addEventListener('click', () => {
            showCustomNotification('Esta sección es solo de visualización y configuración de metas. Los datos se generan automáticamente en un sistema real.', 'info', 5000);
        });
    }

    // El modal de confirmación solo se usa para la acción de "eliminar" o "realizar acción",
    // en este dashboard de rendimiento no hay acciones de ese tipo directamente en la UI.
    // La función openConfirmActionModal está disponible si la necesitaras en el futuro.
    if (confirmDeleteButton) { // Es el botón interno del modal de confirmación
        confirmDeleteButton.addEventListener('click', function() {
            // Esta lógica se manejaría directamente en la función `openConfirmActionModal`
            // a través del callback que se le pase. No necesita un listener aquí.
        });
    }

    // Se re-renderizan los iconos de Lucide al cargar el DOM
    lucide.createIcons();
    console.log("[dashboard.php] Página de dashboard inicializada.");
});
</script>
</body>
</html>