<?php
// db/academy-create.php
ob_start(); // Iniciar el búfer de salida
error_reporting(0); // Desactivar la muestra de errores en producción
ini_set('display_errors', 0); // Desactivar la muestra de errores en producción

include_once 'db_connection.php'; // Incluir el archivo de conexión a la base de datos

$response = ['success' => false, 'message' => '', 'course' => null];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en academy-create.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input)) {
        $response['message'] = 'Datos de solicitud vacíos o no válidos.';
        echo json_encode($response);
        exit();
    }

    $title = trim($input['titulo'] ?? '');
    $url = trim($input['url'] ?? '');
    $poster_url = trim($input['poster_url'] ?? '') ?: null; // Campo nuevo
    $description = trim($input['descripcion'] ?? '');

    if (empty($title) || empty($url)) {
        $response['message'] = 'El título y la URL del curso son obligatorios.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // CAMBIO: Añadir poster_url a la consulta INSERT
        $stmt = $pdo->prepare("INSERT INTO academy (title, description, url, poster_url) VALUES (:title, :description, :url, :poster_url)");
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':description', $description);
        $stmt->bindParam(':url', $url);
        $stmt->bindParam(':poster_url', $poster_url); // Bind del nuevo parámetro

        if ($stmt->execute()) {
            $last_id = $pdo->lastInsertId();
            $response['success'] = true;
            $response['message'] = 'Curso agregado con éxito.';
            $response['course'] = [
                'id' => $last_id, // El ID numérico de la DB
                'titulo' => $title,
                'descripcion' => $description,
                'url' => $url,
                'poster_url' => $poster_url, // Incluir en la respuesta
                'created_at' => date('Y-m-d H:i:s') // Usar la fecha actual del servidor
            ];
        } else {
            $response['message'] = 'Error al guardar el curso en la base de datos.';
        }
        $pdo->commit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al crear curso de academia: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al crear curso: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al crear curso de academia: " . $e->getMessage());
        $response['message'] = 'Error inesperado al crear curso: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean(); // Limpiar el búfer de salida
header('Content-Type: application/json'); // Establecer el tipo de contenido a JSON
echo json_encode($response); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script