<?php
// db/academy-read.php
ob_start(); // Iniciar el búfer de salida
error_reporting(0); // Desactivar la muestra de errores en producción
ini_set('display_errors', 0); // Desactivar la muestra de errores en producción

include_once 'db_connection.php'; // Incluir el archivo de conexión a la base de datos

$response_data = ['success' => false, 'data' => null, 'message' => ''];

try {
    // CAMBIO: Seleccionar también el campo 'poster_url' de la base de datos
    $stmt = $pdo->prepare("SELECT id, title, description, url, poster_url, created_at FROM academy ORDER BY created_at DESC");
    $stmt->execute();
    $courses = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Convertir el array de cursos a un objeto indexado por un ID de JavaScript
    $indexed_courses = [];
    foreach ($courses as $course) {
        $indexed_courses['course-' . $course['id']] = [
            'id' => 'course-' . $course['id'], // ID para JS (string)
            'db_id' => $course['id'],        // ID de la base de datos (numérico)
            'titulo' => $course['title'],
            'descripcion' => $course['description'],
            'url' => $course['url'],
            'poster_url' => $course['poster_url'], // Añadido poster_url
            'created_at' => $course['created_at']
        ];
    }

    $response_data = ['success' => true, 'data' => $indexed_courses];

} catch (PDOException $e) {
    error_log("Error PDO al cargar cursos de academia: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar cursos: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("Error general al cargar cursos de academia: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar cursos: ' . $e->getMessage();
}

ob_end_clean(); // Limpiar el búfer de salida
header('Content-Type: application/json'); // Establecer el tipo de contenido a JSON
echo json_encode($response_data); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script