<?php
// db/academy-update.php
ob_start(); // Iniciar el búfer de salida
error_reporting(0); // Desactivar la muestra de errores en producción
ini_set('display_errors', 0); // Desactivar la muestra de errores en producción

include_once 'db_connection.php'; // Incluir el archivo de conexión a la base de datos

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en academy-update.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input) || empty($input['id'])) {
        $response['message'] = 'ID de curso es obligatorio.';
        echo json_encode($response);
        exit();
    }

    $id = $input['id'] ?? null; // Este es el db_id numérico
    $title = trim($input['titulo'] ?? '');
    $url = trim($input['url'] ?? '');
    $poster_url = trim($input['poster_url'] ?? '') ?: null; // Campo nuevo
    $description = trim($input['descripcion'] ?? '');

    if (empty($id) || empty($title) || empty($url)) {
        $response['message'] = 'ID de curso, título y URL son obligatorios.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // CAMBIO: Añadir poster_url a la consulta UPDATE
        $stmt = $pdo->prepare("UPDATE academy SET title = :title, description = :description, url = :url, poster_url = :poster_url WHERE id = :id");
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':description', $description);
        $stmt->bindParam(':url', $url);
        $stmt->bindParam(':poster_url', $poster_url); // Bind del nuevo parámetro
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Curso actualizado con éxito.';
        } else {
            $response['message'] = 'Error al actualizar el curso en la base de datos.';
        }
        $pdo->commit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al actualizar curso de academia: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al actualizar curso: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al actualizar curso de academia: " . $e->getMessage());
        $response['message'] = 'Error inesperado al actualizar curso: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean(); // Limpiar el búfer de salida
header('Content-Type: application/json'); // Establecer el tipo de contenido a JSON
echo json_encode($response); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script