<?php
// db/clients-read.php
ob_start(); // Iniciar el búfer de salida
error_reporting(0); // Desactivar la muestra de errores en producción
ini_set('display_errors', 0); // Desactivar la muestra de errores en producción

include_once 'db_connection.php'; // Incluir el archivo de conexión a la base de datos

$response_data = ['success' => false, 'data' => null, 'total_count' => 0, 'monthly_count' => 0, 'months_data' => [], 'message' => ''];

try {
    // Obtener parámetros de filtro mensual
    $selected_year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');
    $selected_month = isset($_GET['month']) ? (int)$_GET['month'] : date('m');

    // 1. Obtener todos los clientes
    $stmt = $pdo->query("
        SELECT
            id,
            first_name,
            last_name,
            email,
            phone,
            mobile,
            state_province,
            created_at
        FROM
            clients
        ORDER BY created_at DESC
    ");
    $clients_db_raw = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $clients_indexed = [];
    $total_clients_count = 0;
    $monthly_clients_count = 0;
    $unique_months_present_keys = []; // Usamos array para meses únicos y luego convertir a Set en JS

    foreach ($clients_db_raw as $client) {
        $client_id = $client['id'];
        $indexed_id = 'client-' . $client_id;

        // Obtener los IDs de servicios asignados a este cliente
        $stmt_services = $pdo->prepare("SELECT service_id FROM client_services WHERE client_id = :client_id");
        $stmt_services->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $stmt_services->execute();
        $assigned_service_ids = $stmt_services->fetchAll(PDO::FETCH_COLUMN, 0); // Solo queremos los IDs

        // Obtener los nombres de los servicios para la visualización
        $service_names_array = [];
        if (!empty($assigned_service_ids)) {
            $placeholders = implode(',', array_fill(0, count($assigned_service_ids), '?'));
            $stmt_names = $pdo->prepare("SELECT name FROM services WHERE id IN ($placeholders)");
            foreach ($assigned_service_ids as $key => $id) {
                $stmt_names->bindValue(($key + 1), $id, PDO::PARAM_INT);
            }
            $stmt_names->execute();
            $service_names_array = $stmt_names->fetchAll(PDO::FETCH_COLUMN, 0);
        }

        $clients_indexed[$indexed_id] = [
            'id' => $client_id,
            'nombre' => $client['first_name'],
            'apellido' => $client['last_name'],
            'email' => $client['email'],
            'phone' => $client['phone'],
            'mobile' => $client['mobile'],
            'state_province' => $client['state_province'],
            'created_at' => $client['created_at'],
            'service_ids' => array_map('intval', $assigned_service_ids), // Asegurar que sean enteros
            'servicios' => implode(', ', $service_names_array), // String con nombres de servicios
            'ciudad' => $client['state_province'], // Usar state_province como ciudad por ahora
            'estado' => $client['state_province'] // Usar state_province como estado por ahora
        ];
        $total_clients_count++;

        // Contar clientes nuevos este mes y registrar meses con clientes
        $createdAtDate = new DateTime($client['created_at']);
        $clientMonth = (int)$createdAtDate->format('m');
        $clientYear = (int)$createdAtDate->format('Y');

        if ($clientYear == $selected_year && $clientMonth == $selected_month) {
            $monthly_clients_count++;
        }
        $ym_key = "{$clientYear}-" . str_pad($clientMonth, 2, '0', STR_PAD_LEFT);
        if (!in_array($ym_key, $unique_months_present_keys)) {
            $unique_months_present_keys[] = $ym_key;
        }
    }
    
    // Preparar months_with_clients_data para el frontend (ordenar para que los más recientes aparezcan primero)
    $months_with_clients_data = [];
    foreach ($unique_months_present_keys as $ym) {
        list($y, $m) = explode('-', $ym);
        $months_with_clients_data[] = ['year' => (int)$y, 'month' => (int)$m];
    }
    usort($months_with_clients_data, function($a, $b) {
        if ($a['year'] == $b['year']) {
            return $b['month'] - $a['month'];
        }
        return $b['year'] - $a['year'];
    });

    // Obtener todos los servicios disponibles para los filtros y el autocompletado
    $stmt_all_services = $pdo->query("SELECT id, name FROM services ORDER BY name ASC");
    $available_services = $stmt_all_services->fetchAll(PDO::FETCH_ASSOC);

    $response_data = [
        'success' => true,
        'data' => $clients_indexed,
        'available_services' => $available_services,
        'total_clients_count' => $total_clients_count,
        'monthly_clients_count' => $monthly_clients_count,
        'selected_month' => $selected_month,
        'selected_year' => $selected_year,
        'months_with_clients' => $months_with_clients_data
    ];

} catch (PDOException $e) {
    error_log("Error PDO al cargar clientes: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar clientes: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("Error general al cargar clientes: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar clientes: ' . $e->getMessage();
}

ob_end_clean(); // Limpiar el búfer de salida
header('Content-Type: application/json'); // Establecer el tipo de contenido a JSON
echo json_encode($response_data); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script