<?php
// db/services-read.php
ob_start(); // Iniciar el búfer de salida
error_reporting(0); // Desactivar la muestra de errores en producción
ini_set('display_errors', 0); // Desactivar la muestra de errores en producción

include_once 'db_connection.php'; // Incluir el archivo de conexión a la base de datos

$response_data = ['success' => false, 'data' => null, 'total_count' => 0, 'new_this_month_count' => 0, 'categories' => [], 'message' => ''];

try {
    // Obtener todos los servicios
    $stmt_services = $pdo->prepare("SELECT id, name, price, category, description, created_at FROM services ORDER BY name ASC");
    $stmt_services->execute();
    $services_db_raw = $stmt_services->fetchAll(PDO::FETCH_ASSOC);

    $services_indexed = [];
    $total_services_count = 0;
    $new_services_this_month = 0;
    $unique_categories = []; // Para almacenar nombres de categorías únicas

    $current_month_year = date('Y-m');

    foreach ($services_db_raw as $service) {
        $service_id = $service['id'];
        $indexed_id = 'service-' . $service_id;

        $services_indexed[$indexed_id] = [
            'id' => $indexed_id, // ID para JS (string)
            'db_id' => $service_id, // ID numérico de la DB
            'nombre' => $service['name'],
            'precio' => (float)$service['price'],
            'categoria' => $service['category'],
            'descripcion' => $service['description'],
            'created_at' => $service['created_at']
        ];
        $total_services_count++;

        // Contar servicios nuevos este mes
        if (isset($service['created_at'])) {
            $created_month_year = (new DateTime($service['created_at']))->format('Y-m');
            if ($created_month_year === $current_month_year) {
                $new_services_this_month++;
            }
        }

        // Recopilar categorías únicas
        if (!empty($service['category']) && !in_array($service['category'], $unique_categories)) {
            $unique_categories[] = $service['category'];
        }
    }

    // Convertir categorías a un formato de objeto si es necesario, o mantener como array de strings
    $categories_for_frontend = [];
    foreach ($unique_categories as $index => $cat_name) {
        $categories_for_frontend[] = ['id' => $index + 1, 'name' => $cat_name]; // Asignar un ID simple
    }

    $response_data = [
        'success' => true,
        'data' => $services_indexed,
        'total_count' => $total_services_count,
        'new_this_month_count' => $new_services_this_month,
        'categories' => $categories_for_frontend // Enviar las categorías únicas
    ];

} catch (PDOException $e) {
    error_log("Error PDO al cargar servicios: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar servicios: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("Error general al cargar servicios: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar servicios: ' . $e->getMessage();
}

ob_end_clean(); // Limpiar el búfer de salida
header('Content-Type: application/json'); // Establecer el tipo de contenido a JSON
echo json_encode($response_data); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script