<?php
// db/user-monthly-goal-update.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en user-monthly-goal-update.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    
    $monthly_billing_goal = $input['monthly_billing_goal'] ?? null;

    // Asumimos que actualizaremos la meta del administrador con ID 1.
    $admin_id = 1; // ¡CAMBIA ESTO SI TU ADMINISTRADOR TIENE UN ID DIFERENTE!

    if ($monthly_billing_goal === null || !is_numeric($monthly_billing_goal) || $monthly_billing_goal < 0) {
        $response['message'] = 'Meta de facturación inválida. Por favor, introduce una cantidad numérica positiva.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // Prepara y ejecuta la consulta para actualizar la meta mensual
        $stmt = $pdo->prepare("UPDATE admin SET monthly_billing_goal = :goal, updated_at = NOW() WHERE id = :id");
        $stmt->bindParam(':goal', $monthly_billing_goal);
        $stmt->bindParam(':id', $admin_id, PDO::PARAM_INT);
        
        if ($stmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Meta mensual actualizada con éxito.';
        } else {
            $response['message'] = 'Error al guardar la meta en la base de datos.';
        }
        $pdo->commit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al actualizar la meta mensual: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al actualizar la meta: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al actualizar la meta mensual: " . $e->getMessage());
        $response['message'] = 'Error interno al actualizar la meta: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>