<?php
// db/user-profile-read.php
ob_start(); // Iniciar el buffer de salida
// Opcional: Desactivar errores en producción. db_connection.php ya los maneja para depuración.
error_reporting(0); 
ini_set('display_errors', 0);

// Incluir el archivo de conexión a la base de datos desde la misma carpeta 'db/'
include_once 'db_connection.php';

$response_data = ['success' => false, 'data' => null, 'message' => ''];

try {
    // Asumimos que solo hay UN administrador y su ID es 1.
    // SI TU ADMINISTRADOR TIENE UN ID DIFERENTE EN LA TABLA 'admin', ¡CÁMBIALO AQUÍ!
    $admin_id = 1; 

    // Selecciona los campos necesarios de la tabla 'admin'
    $stmt = $pdo->prepare("SELECT full_name, email, profile_photo_url, monthly_billing_goal FROM admin WHERE id = :id");
    $stmt->bindParam(':id', $admin_id, PDO::PARAM_INT);
    $stmt->execute();
    $profile = $stmt->fetch(); // Obtiene los resultados como un array asociativo

    if ($profile) {
        $response_data = ['success' => true, 'data' => $profile];
    } else {
        $response_data['message'] = 'No se encontró el perfil de administrador con ID ' . $admin_id . '. Asegúrate de que exista en la tabla "admin".';
    }

} catch (PDOException $e) {
    error_log("Error PDO al cargar perfil de administrador: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar perfil: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("Error general al cargar perfil de administrador: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar perfil: ' . $e->getMessage();
}

ob_end_clean(); // Limpiar cualquier salida inesperada antes de enviar el JSON
header('Content-Type: application/json'); // Asegurar que la cabecera sea JSON
echo json_encode($response_data); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script
?>