<?php
ob_start(); // Iniciar el búfer de salida al inicio del script
session_start();

// ***** IMPORTANTE: ESTAS LÍNEAS ESTÁN AQUÍ PARA DEPURAR. *****
// UNA VEZ QUE FUNCIONE, CÁMBIALAS A: error_reporting(0); ini_set('display_errors', 0);
error_reporting(E_ALL); // Reporta todos los errores
ini_set('display_errors', 1); // Muestra los errores en la pantalla
// *************************************************************

// --- DATOS DE ADMINISTRADOR DE EJEMPLO ---
$admin_data = [
    'nombre' => 'María Admin',
    'email' => 'maria.admin@example.com',
    'foto_perfil' => 'https://placehold.co/100x100/4c7c59/ffffff?text=MA' // Ejemplo de imagen
];

// Obtener el período de filtro de la URL si existe, de lo contrario usar el mes actual
$current_month_year_php = date('Y-m');
$selected_filter_period = $_GET['period'] ?? $current_month_year_php;

// --- Métricas de Rendimiento DUMMY (Mensuales) ---
// Estos datos deberían corresponder al mes seleccionado en $selected_filter_period
// Para un sistema real, aquí harías una consulta a la base de datos basada en $selected_filter_period
$dummy_metrics = [
    '2024-07' => [
        'total_clients_month' => 50,
        'total_sales_month' => 2500.00,
        'average_sale_value_month' => 100.00, // 2500 / (2500/100) = 100
        'conversion_rate_month' => 15.2, // en porcentaje
        'new_leads_month' => 120,
        'customer_retention_month' => 85.5 // en porcentaje
    ],
    '2024-06' => [
        'total_clients_month' => 45,
        'total_sales_month' => 2200.00,
        'average_sale_value_month' => 100.00,
        'conversion_rate_month' => 14.0,
        'new_leads_month' => 110,
        'customer_retention_month' => 84.0
    ],
    '2024-05' => [
        'total_clients_month' => 40,
        'total_sales_month' => 2000.00,
        'average_sale_value_month' => 100.00,
        'conversion_rate_month' => 13.5,
        'new_leads_month' => 105,
        'customer_retention_month' => 83.0
    ],
    '2024-04' => [
        'total_clients_month' => 38,
        'total_sales_month' => 1850.00,
        'average_sale_value_month' => 102.78, // 1850 / 18
        'conversion_rate_month' => 12.8,
        'new_leads_month' => 98,
        'customer_retention_month' => 82.0
    ]
];
// Obtener las métricas para el período seleccionado, si no existe, usar las del mes actual por defecto o valores cero
$performance_metrics = $dummy_metrics[$selected_filter_period] ?? $dummy_metrics[$current_month_year_php] ?? [
    'total_clients_month' => 0,
    'total_sales_month' => 0.00,
    'average_sale_value_month' => 0.00,
    'conversion_rate_month' => 0.0,
    'new_leads_month' => 0,
    'customer_retention_month' => 0.0
];


// --- Datos DUMMY para Desglose Mensual (para la tabla general de meses) ---
$monthly_performance_data_all = [
    ['month_year' => 'Julio 2024', 'clients_acquired' => 50, 'sales_made' => 25, 'revenue_generated' => 2500.00],
    ['month_year' => 'Junio 2024', 'clients_acquired' => 45, 'sales_made' => 22, 'revenue_generated' => 2200.00],
    ['month_year' => 'Mayo 2024', 'clients_acquired' => 40, 'sales_made' => 20, 'revenue_generated' => 2000.00],
    ['month_year' => 'Abril 2024', 'clients_acquired' => 38, 'sales_made' => 18, 'revenue_generated' => 1850.00],
];

// --- Datos DUMMY para Desglose Semanal (para el mes actual seleccionado) ---
// Estos datos se "filtran" para el mes actualmente seleccionado ($selected_filter_period)
// Aquí, la lógica debería ser más compleja en un entorno real para obtener semanas precisas
// que cruzan meses, pero para dummy data, solo se mapean a $selected_filter_period
$weekly_performance_data_for_selected_month = [];
if ($selected_filter_period === '2024-07') {
    $weekly_performance_data_for_selected_month = [
        ['week_label' => 'Semana 28 (08-14 Jul)', 'clients_acquired' => 12, 'sales_made' => 6, 'revenue_generated' => 650.00],
        ['week_label' => 'Semana 27 (01-07 Jul)', 'clients_acquired' => 15, 'sales_made' => 8, 'revenue_generated' => 800.00],
        ['week_label' => 'Semana 26 (24-30 Jun)', 'clients_acquired' => 10, 'sales_made' => 5, 'revenue_generated' => 500.00], // Podría ser del mes anterior
        ['week_label' => 'Semana 25 (17-23 Jun)', 'clients_acquired' => 10, 'sales_made' => 6, 'revenue_generated' => 600.00], // Podría ser del mes anterior
    ];
} elseif ($selected_filter_period === '2024-06') {
     $weekly_performance_data_for_selected_month = [
        ['week_label' => 'Semana 24 (10-16 Jun)', 'clients_acquired' => 11, 'sales_made' => 5, 'revenue_generated' => 550.00],
        ['week_label' => 'Semana 23 (03-09 Jun)', 'clients_acquired' => 10, 'sales_made' => 6, 'revenue_generated' => 600.00],
        ['week_label' => 'Semana 22 (27 May-02 Jun)', 'clients_acquired' => 9, 'sales_made' => 4, 'revenue_generated' => 450.00], // Cruza meses
    ];
}
// etc. para otros meses

// Se pueden definir años y meses para filtros si se desea
$available_months_years = [
    ['year' => 2024, 'month' => 7, 'label' => 'Julio 2024'],
    ['year' => 2024, 'month' => 6, 'label' => 'Junio 2024'],
    ['year' => 2024, 'month' => 5, 'label' => 'Mayo 2024'],
    ['year' => 2024, 'month' => 4, 'label' => 'Abril 2024'],
];


// --- NUEVO: Datos para gráficos de comparación (siempre los últimos 4 meses) ---
// Estos datos se obtienen de $monthly_performance_data_all, ordenándolos por fecha
$chart_data_sorted = array_reverse($monthly_performance_data_all); // Para que el más antiguo sea el primero en el gráfico

$chart_months_labels = [];
$chart_revenue_data = [];
$chart_clients_data = [];

// Obtener los últimos N meses (ej. 4)
$num_months_for_chart = 4;
$recent_months_data = array_slice($chart_data_sorted, 0, $num_months_for_chart);
$recent_months_data = array_reverse($recent_months_data); // Volver a ordenar para que el más reciente sea el último

foreach ($recent_months_data as $data) {
    $chart_months_labels[] = explode(' ', $data['month_year'])[0]; // Solo el nombre del mes
    $chart_revenue_data[] = $data['revenue_generated'];
    $chart_clients_data[] = $data['clients_acquired'];
}

// Métricas clave para el gráfico de barras (usando las métricas del mes seleccionado)
$chart_metrics_labels = ['Clientes', 'Ventas', 'Leads', 'Retención'];
$chart_metrics_values = [
    $performance_metrics['total_clients_month'],
    $performance_metrics['total_sales_month'] / ($performance_metrics['average_sale_value_month'] > 0 ? $performance_metrics['average_sale_value_month'] : 1), // Evitar división por cero
    $performance_metrics['new_leads_month'],
    $performance_metrics['customer_retention_month']
];
// --- FIN Datos para gráficos ---


$performance_metrics_json = json_encode($performance_metrics);
$monthly_performance_json = json_encode($monthly_performance_data_all); // Se usa all para la tabla
$weekly_performance_json = json_encode($weekly_performance_data_for_selected_month); // Solo semanas del mes seleccionado

$available_months_years_json = json_encode($available_months_years);
$selected_filter_period_json = json_encode($selected_filter_period);

$chart_revenue_json = json_encode($chart_revenue_data);
$chart_clients_json = json_encode($chart_clients_data);
$chart_months_labels_json = json_encode($chart_months_labels);

$chart_metrics_labels_json = json_encode($chart_metrics_labels);
$chart_metrics_values_json = json_encode($chart_metrics_values);


$notification_message = '';
$notification_type = '';
if (isset($_SESSION['notification'])) {
    $notification_message = $_SESSION['notification']['message'];
    $notification_type = $_SESSION['notification']['type'];
    unset($_SESSION['notification']);
}
ob_end_clean();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit Dashboard | Resumen de Rendimiento</title>
    <meta name="description" content="Monitorea el rendimiento mensual y semanal de tu negocio con métricas clave en LocalCRM.">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">


    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script>
</head>
 
<body data-page-title="PANEL DE ADMINISTRADOR - RENDIMIENTO"
      data-page-subtitle="RESUMEN MENSUAL DEL NEGOCIO"
      data-page-icon="bar-chart-2">

<div id="toastNotification" class="toast-notification">
    <i id="toastIcon" class="fas"></i>
    <span id="toastMessage"></span>
    <button id="toastCloseBtn" class="toast-close-btn">×</button>
</div>
<style>
.toast-notification {
    visibility: hidden;
    min-width: 250px;
    background-color: #333;
    color: #fff;
    text-align: center;
    border-radius: 8px;
    padding: 16px;
    position: fixed;
    z-index: 1000;
    left: 50%;
    transform: translateX(-50%);
    bottom: 30px;
    font-size: 17px;
    display: flex;
    align-items: center;
    gap: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    opacity: 0;
    transition: opacity 0.5s, bottom 0.5s;
}

.toast-notification.show {
    visibility: visible;
    opacity: 1;
    bottom: 50px;
}

.toast-notification.success { background-color: #4CAF50; }
.toast-notification.error { background-color: #f44336; }
.toast-notification.info { background-color: #2196F3; }

.toast-notification .toast-close-btn {
    background: none;
    border: none;
    color: white;
    font-size: 20px;
    cursor: pointer;
    margin-left: auto;
}
</style>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

<?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container" id="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-8">
            <section id="performance-overview-section" class="dashboard-section">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="bar-chart-2" class="w-7 h-7 text-[var(--color-primary)]"></i> RESUMEN DE RENDIMIENTO MENSUAL
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">MÉTRICAS CLAVE DEL NEGOCIO.</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-green-500">
                            <i data-lucide="users" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">CLIENTES NUEVOS (MES)</h3>
                                <p id="total-clients-month" class="text-5xl font-bold text-green-700">0</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-primary)]">
                            <i data-lucide="dollar-sign" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">VENTAS TOTALES (MES)</h3>
                                <p id="total-sales-month" class="text-5xl font-bold text-[var(--color-secondary)]">$0.00</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-purple-500">
                            <i data-lucide="tag" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">VALOR PROMEDIO VENTA</h3>
                                <p id="average-sale-value-month" class="text-5xl font-bold text-purple-700">$0.00</p>
                            </div>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-blue-500">
                            <i data-lucide="percent" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">TASA DE CONVERSIÓN</h3>
                                <p id="conversion-rate-month" class="text-5xl font-bold text-blue-700">0%</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-highlight)]">
                            <i data-lucide="lightbulb" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">NUEVOS LEADS (MES)</h3>
                                <p id="new-leads-month" class="text-5xl font-bold text-[var(--color-highlight)]">0</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-orange-500">
                            <i data-lucide="award" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">RETENCIÓN DE CLIENTES</h3>
                                <p id="customer-retention-month" class="text-5xl font-bold text-orange-700">0%</p>
                            </div>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mt-8">
                        <div class="bg-white p-6 rounded-xl shadow-md">
                            <h3 class="text-xl font-extrabold text-gray-800 flex items-center gap-2 mb-4">
                                <i data-lucide="line-chart" class="w-6 h-6 text-[var(--color-primary)]"></i> TENDENCIA DE INGRESOS GENERADOS
                            </h3>
                            <div class="relative h-72"><canvas id="revenueTrendChart"></canvas></div>
                        </div>
                        <div class="bg-white p-6 rounded-xl shadow-md">
                            <h3 class="text-xl font-extrabold text-gray-800 flex items-center gap-2 mb-4">
                                <i data-lucide="bar-chart" class="w-6 h-6 text-[var(--color-primary)]"></i> COMPARACIÓN DE MÉTRICAS CLAVE
                            </h3>
                            <div class="relative h-72"><canvas id="keyMetricsComparisonChart"></canvas></div>
                        </div>
                    </div>
                    </div>
            </section>

            <section id="monthly-performance-section" class="dashboard-section mt-8">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="calendar" class="w-7 h-7 text-[var(--color-primary)]"></i> DESGLOSE MENSUAL
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">RENDIMIENTO DETALLADO POR MES.</p>
                        </div>
                        <div class="flex items-center gap-4 w-full md:w-auto">
                            <select id="monthly-performance-filter-period" class="w-full md:w-48 p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)] bg-white">
                                </select>
                            <button id="download-monthly-performance-btn" class="btn-primary font-bold py-2 px-4 rounded-lg flex items-center w-full md:w-auto justify-center uppercase text-sm">
                                <i data-lucide="download" class="w-4 h-4 mr-2"></i> DESCARGAR
                            </button>
                        </div>
                    </div>

                    <div id="monthly-performance-list-view" class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-50">
                                <tr class="text-left text-gray-500 uppercase text-sm">
                                    <th class="py-3 px-6 font-semibold">PERIODO</th>
                                    <th class="py-3 px-6 font-semibold">CLIENTES ADQUIRIDOS</th>
                                    <th class="py-3 px-6 font-semibold">VENTAS REALIZADAS</th>
                                    <th class="py-3 px-6 font-semibold">INGRESOS GENERADOS</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-700 text-sm" id="monthlyPerformanceTableBody">
                                </tbody>
                        </table>
                    </div>
                </div>
            </section>
            
            <section id="weekly-performance-section" class="dashboard-section mt-8">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="calendar-range" class="w-7 h-7 text-[var(--color-primary)]"></i> DESGLOSE SEMANAL
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">RENDIMIENTO DETALLADO POR SEMANA.</p>
                        </div>
                        <div class="flex items-center gap-4 w-full md:w-auto">
                            <select id="weekly-performance-filter-period" class="w-full md:w-48 p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)] bg-white">
                                </select>
                            <button id="download-weekly-performance-btn" class="btn-primary font-bold py-2 px-4 rounded-lg flex items-center w-full md:w-auto justify-center uppercase text-sm">
                                <i data-lucide="download" class="w-4 h-4 mr-2"></i> DESCARGAR
                            </button>
                        </div>
                    </div>

                    <div id="weekly-performance-list-view" class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-50">
                                <tr class="text-left text-gray-500 uppercase text-sm">
                                    <th class="py-3 px-6 font-semibold">SEMANA</th>
                                    <th class="py-3 px-6 font-semibold">CLIENTES ADQUIRIDOS</th>
                                    <th class="py-3 px-6 font-semibold">VENTAS REALIZADAS</th>
                                    <th class="py-3 px-6 font-semibold">INGRESOS GENERADOS</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-700 text-sm" id="weeklyPerformanceTableBody">
                                </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<div id="confirmDeleteModal" class="fixed inset-0 bg-gray-900 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white p-8 rounded-xl shadow-2xl w-full max-w-sm m-4 transform transition-all duration-300 scale-95 opacity-0 text-center">
        <div class="flex justify-center mb-4">
            <i data-lucide="alert-triangle" class="w-16 h-16 text-red-500"></i>
        </div>
        <h3 class="text-2xl font-bold text-[var(--color-primary)] mb-4 uppercase">CONFIRMAR ACCIÓN</h3>
        <p class="text-gray-700 mb-6 uppercase">¿ESTÁS SEGURO DE QUE DESEAS REALIZAR ESTA ACCIÓN?</p>
        <div class="flex justify-center space-x-4">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closeModal('confirmDeleteModal')">CANCELAR</button>
            <button type="button" class="btn-secondary font-bold py-2 px-4 rounded-lg uppercase" id="confirm-delete-button">CONFIRMAR</button>
        </div>
    </div>
</div>


<script>
// Variables globales para los datos (dummy)
let performanceMetrics = (function() {
    try {
        const data = <?php echo $performance_metrics_json; ?>;
        return (typeof data === 'object' && data !== null) ? data : {};
    } catch (e) {
        console.error("Error al parsear performance_metrics_json:", e);
        return {};
    }
})();

let monthlyPerformanceData = (function() {
    try {
        const data = <?php echo $monthly_performance_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear monthly_performance_json:", e);
        return [];
    }
})();

let weeklyPerformanceData = (function() {
    try {
        const data = <?php echo $weekly_performance_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear weekly_performance_json:", e);
        return [];
    }
})();

let availableMonthsYears = (function() {
    try {
        const data = <?php echo $available_months_years_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear available_months_years_json:", e);
        return [];
    }
})();

let selectedFilterPeriod = (function() {
    try {
        const data = <?php echo $selected_filter_period_json; ?>;
        return (typeof data === 'string' || data === null) ? data : '';
    } catch (e) {
        console.error("Error al parsear selected_filter_period_json:", e);
        return '';
    }
})();


// Datos para gráficos (se inicializan directamente desde PHP, ya vienen procesados)
const chartMonthsLabels = (function() {
    try {
        const data = <?php echo $chart_months_labels_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear chart_months_labels_json:", e);
        return [];
    }
})();

const chartRevenueData = (function() {
    try {
        const data = <?php echo $chart_revenue_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear chart_revenue_json:", e);
        return [];
    }
})();

const chartKeyMetricsLabels = (function() {
    try {
        const data = <?php echo $chart_metrics_labels_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear chart_metrics_labels_json:", e);
        return [];
    }
})();

const chartKeyMetricsValues = (function() {
    try {
        const data = <?php echo $chart_metrics_values_json; ?>;
        return (Array.isArray(data)) ? data : [];
    } catch (e) {
        console.error("Error al parsear chart_metrics_values_json:", e);
        return [];
    }
})();


document.addEventListener('DOMContentLoaded', function() {
    // --- CONSOLE.LOGS PARA DEPURACIÓN ---
    console.log("--- Depuración de performance.php ---");
    console.log("performanceMetrics:", performanceMetrics);
    console.log("monthlyPerformanceData:", monthlyPerformanceData);
    console.log("weeklyPerformanceData:", weeklyPerformanceData);
    console.log("availableMonthsYears:", availableMonthsYears);
    console.log("selectedFilterPeriod:", selectedFilterPeriod);
    console.log("chartMonthsLabels:", chartMonthsLabels);
    console.log("chartRevenueData:", chartRevenueData);
    console.log("chartKeyMetricsLabels:", chartKeyMetricsLabels);
    console.log("chartKeyMetricsValues:", chartKeyMetricsValues);
    // --- FIN CONSOLE.LOGS PARA DEPURACIÓN ---


    // --- VARIABLES DOM LOCALES ---
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebar-overlay');
    const sidebarCloseBtn = document.getElementById('sidebarCloseBtn');
    
    // Métricas de Resumen
    const totalClientsMonthElement = document.getElementById('total-clients-month');
    const totalSalesMonthElement = document.getElementById('total-sales-month');
    const averageSaleValueMonthElement = document.getElementById('average-sale-value-month');
    const conversionRateMonthElement = document.getElementById('conversion-rate-month');
    const newLeadsMonthElement = document.getElementById('new-leads-month');
    const customerRetentionMonthElement = document.getElementById('customer-retention-month');

    // Desglose Mensual
    const monthlyPerformanceTableBody = document.getElementById('monthlyPerformanceTableBody');
    const monthlyPerformanceFilterPeriod = document.getElementById('monthly-performance-filter-period');
    const downloadMonthlyPerformanceBtn = document.getElementById('download-monthly-performance-btn');
    
    // Desglose Semanal
    const weeklyPerformanceTableBody = document.getElementById('weeklyPerformanceTableBody');
    const weeklyPerformanceFilterPeriod = document.getElementById('weekly-performance-filter-period');
    const downloadWeeklyPerformanceBtn = document.getElementById('download-weekly-performance-btn');

    // Gráficos (obtener los contextos solo si los elementos existen)
    let revenueTrendChartCtx;
    let keyMetricsComparisonChartCtx;
    const revenueTrendCanvas = document.getElementById('revenueTrendChart');
    if (revenueTrendCanvas) {
        revenueTrendChartCtx = revenueTrendCanvas.getContext('2d');
    }
    const keyMetricsComparisonCanvas = document.getElementById('keyMetricsComparisonChart');
    if (keyMetricsComparisonCanvas) {
        keyMetricsComparisonChartCtx = keyMetricsComparisonCanvas.getContext('2d');
    }

    // Botón general "Añadir Dato" del sidebar (no se usará para añadir datos, es solo un placeholder)
    // Asumo que este ID debería estar en el botón del menú lateral si es relevante para esta página.
    const addPerformanceEntryBtn = document.getElementById('addPerformanceEntryBtn'); 

    // Modales de confirmación (compartidos)
    const confirmDeleteModal = document.getElementById('confirmDeleteModal');
    const confirmDeleteButton = document.getElementById('confirm-delete-button');
    const confirmModalTitle = document.getElementById('confirmDeleteModal')?.querySelector('h3');
    const confirmModalMessage = document.getElementById('confirmDeleteModal')?.querySelector('p');

    // Elemento de overlay para los paneles laterales (creado dinámicamente, aunque no se usan paneles de abrir/cerrar en esta página)
    let panelOverlay = document.getElementById('panel-overlay');
    if (!panelOverlay) {
        panelOverlay = document.createElement('div');
        panelOverlay.id = 'panel-overlay';
        panelOverlay.className = 'fixed inset-0 bg-black bg-opacity-50 z-40 hidden';
        document.body.appendChild(panelOverlay);
    }


    // --- FUNCIONES HELPER GLOBALES (reutilizadas) ---

    // Muestra una notificación personalizada (simulada)
    window.showCustomNotification = function(message, type = 'info', duration = 3000) {
        const toast = document.getElementById('toastNotification');
        const toastMessage = document.getElementById('toastMessage');
        const toastIcon = document.getElementById('toastIcon');
        const toastCloseBtn = document.getElementById('toastCloseBtn');
        let toastTimeout;

        if (!toast || !toastMessage || !toastIcon || !toastCloseBtn) {
            console.warn(`[NOTIFICACION - FALLBACK] Elementos de toast no encontrados. Mensaje: ${type.toUpperCase()}: ${message}`);
            return;
        }

        clearTimeout(toastTimeout);
        toast.className = 'toast-notification'; // Resetear clases
        toastIcon.className = 'fas'; // Resetear icono base

        toastMessage.textContent = message;
        toast.classList.add(type === 'success' ? 'success' : (type === 'error' ? 'error' : 'info'));
        
        if (type === 'success') {
            toastIcon.classList.add('fa-check-circle');
        } else if (type === 'error') {
            toastIcon.classList.add('fa-exclamation-circle');
        } else {
            toastIcon.classList.add('fa-info-circle');
        }

        toast.classList.add('show');
        toastTimeout = setTimeout(() => {
            toast.classList.remove('show');
        }, duration);

        toastCloseBtn.onclick = () => {
            clearTimeout(toastTimeout);
            toast.classList.remove('show');
        };

        console.log(`[NOTIFICACION - ${type.toUpperCase()}] ${message}`);
    };

    // Abre/cierra modales (mantener para consistencia, aunque aquí solo el de confirmación)
    // Se renombra a `openPanelInternal` y `closePanelInternal` para evitar conflictos
    // ya que no hay paneles laterales deslizantes en esta página.
    window.openModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (!modal) { console.error(`Error: Modal con ID "${modalId}" no encontrado.`); return; }
        const modalBox = modal.querySelector('div:first-of-type');
        modal.classList.remove('hidden');
        setTimeout(() => { 
            if (modalBox) modalBox.classList.remove('scale-95', 'opacity-0'); 
        }, 50);
        console.log(`[performance.php] Modal ${modalId} abierto.`);
        lucide.createIcons({ container: modal }); // Asegura que los íconos del modal se muestren
    };

    window.closeModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (!modal) { console.error(`Error: Modal con ID "${modalId}" no encontrado para cerrar.`); return; }
        const modalBox = modal.querySelector('div:first-of-type');
        if (modalBox) modalBox.classList.add('scale-95', 'opacity-0');
        setTimeout(() => { modal.classList.add('hidden'); }, 300);
        console.log(`[performance.php] Modal ${modalId} cerrado.`);
    };
    
    // Función de confirmación general (adaptada para este contexto)
    window.openConfirmActionModal = function(actionCallback, title = 'CONFIRMAR ACCIÓN', message = '¿ESTÁS SEGURO DE QUE DESEAS REALIZAR ESTA ACCIÓN?') {
        if (!confirmDeleteButton || !confirmModalTitle || !confirmModalMessage) { showCustomNotification("Error: Elementos del modal de confirmación no encontrados.", 'error'); return; }
        
        confirmModalTitle.textContent = title; 
        confirmModalMessage.textContent = message;
        confirmDeleteButton.onclick = () => { // Asigna el callback al botón de confirmar
            actionCallback();
            closeModal('confirmDeleteModal');
        };
        openModal('confirmDeleteModal'); // Abre el modal
    };


    // Descarga datos como CSV (adaptada para rendimiento)
    function descargarComoCSV(dataArray, filename) {
        if (!Array.isArray(dataArray) || dataArray.length === 0) { showCustomNotification('No hay datos para descargar.', 'info'); return; }
        const escapeCSV = (value) => {
            if (value === null || value === undefined) { return ''; }
            value = String(value);
            if (value.search(/("|,|\n)/g) >= 0) { return `"${value.replace(/"/g, '""')}"`; }
            return value;
        };
        
        let headers = [];
        if (filename.includes('mensual')) {
            headers = ['month_year', 'clients_acquired', 'sales_made', 'revenue_generated'];
        } else if (filename.includes('semanal')) {
            headers = ['week_label', 'clients_acquired', 'sales_made', 'revenue_generated'];
        } else { // Fallback genérico si no se especifica el tipo
            if (dataArray.length > 0) {
                 headers = Object.keys(dataArray[0]);
            } else {
                 showCustomNotification('No se pudieron determinar los encabezados del CSV.', 'error');
                 return;
            }
        }
        
        const csvRows = [headers.map(h => escapeCSV(h.replace(/_/g, ' ').toUpperCase())).join(',')];
        dataArray.forEach(item => {
            const values = headers.map(header => escapeCSV(item[header]));
            csvRows.push(values.join(','));
        });
        const csvContent = csvRows.join('\n');
        const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
        const link = document.createElement('a');
        if (link.download !== undefined) {
            const url = URL.createObjectURL(blob);
            link.setAttribute('href', url); link.setAttribute('download', filename);
            link.style.visibility = 'hidden'; document.body.appendChild(link);
            link.click(); document.body.removeChild(link);
            showCustomNotification('CSV generado y descargado.', 'success');
        } else {
            showCustomNotification('Tu navegador no soporta la descarga directa de archivos.', 'error');
        }
    }


    // --- FUNCIONES ESPECÍFICAS DE RENDIMIENTO ---

    // Actualiza las tarjetas de métricas de resumen en la parte superior
    function updatePerformanceMetricsDisplay() {
        if (totalClientsMonthElement) totalClientsMonthElement.textContent = performanceMetrics.total_clients_month.toString();
        if (totalSalesMonthElement) totalSalesMonthElement.textContent = `$${performanceMetrics.total_sales_month.toFixed(2)}`;
        if (averageSaleValueMonthElement) averageSaleValueMonthElement.textContent = `$${performanceMetrics.average_sale_value_month.toFixed(2)}`;
        if (conversionRateMonthElement) conversionRateMonthElement.textContent = `${performanceMetrics.conversion_rate_month.toFixed(1)}%`;
        if (newLeadsMonthElement) newLeadsMonthElement.textContent = performanceMetrics.new_leads_month.toString();
        if (customerRetentionMonthElement) customerRetentionMonthElement.textContent = `${performanceMetrics.customer_retention_month.toFixed(1)}%`;
    }

    // Llena los selectores de filtro de mes/año con las opciones disponibles
    function populateMonthYearFilters() {
        if (!monthlyPerformanceFilterPeriod || !weeklyPerformanceFilterPeriod) return;

        // Limpiar opciones existentes
        monthlyPerformanceFilterPeriod.innerHTML = '';
        weeklyPerformanceFilterPeriod.innerHTML = '';

        availableMonthsYears.forEach(period => {
            const optionValue = `${period.year}-${String(period.month).padStart(2, '0')}`;
            
            const optionMonthly = document.createElement('option');
            optionMonthly.value = optionValue;
            optionMonthly.textContent = period.label.toUpperCase();
            // Seleccionar la opción si coincide con el período de filtro actual
            if (optionValue === selectedFilterPeriod) {
                optionMonthly.selected = true;
            }
            monthlyPerformanceFilterPeriod.appendChild(optionMonthly);

            const optionWeekly = optionMonthly.cloneNode(true); // Clonar para el otro selector
            weeklyPerformanceFilterPeriod.appendChild(optionWeekly);
        });
    }

    // Renderiza la tabla de desglose mensual
    function renderMonthlyPerformance() {
        if (!monthlyPerformanceTableBody) return;
        monthlyPerformanceTableBody.innerHTML = '';

        // Filtrar datos mensuales si es necesario (el dummy PHP ya lo hace en cierta medida)
        // En este ejemplo, monthlyPerformanceData ya contiene todos los meses,
        // por lo que este filtro no es estrictamente necesario a menos que quieras
        // mostrar solo un subconjunto específico. Por ahora, muestra todo.
        const dataToRender = monthlyPerformanceData; // Puedes aplicar un filtro aquí si el HTML tuviera más opciones

        if (dataToRender.length === 0) {
            monthlyPerformanceTableBody.innerHTML = `<tr><td colspan="4" class="py-4 px-6 text-center text-gray-500 uppercase">NO HAY DATOS MENSUALES PARA MOSTRAR.</td></tr>`;
        } else {
            dataToRender.forEach(data => {
                const row = document.createElement('tr');
                row.className = 'border-b border-gray-200 hover:bg-gray-50';
                row.innerHTML = `
                    <td class="py-4 px-6 font-semibold uppercase">${data.month_year}</td>
                    <td class="py-4 px-6 text-center">${data.clients_acquired}</td>
                    <td class="py-4 px-6 text-center">${data.sales_made}</td>
                    <td class="py-4 px-6 text-right">$${data.revenue_generated.toFixed(2)}</td>
                `;
                monthlyPerformanceTableBody.appendChild(row);
            });
        }
    }

    // Renderiza la tabla de desglose semanal
    function renderWeeklyPerformance() {
        if (!weeklyPerformanceTableBody) return;
        weeklyPerformanceTableBody.innerHTML = '';

        // `weeklyPerformanceData` ya viene filtrado desde PHP para el `selected_filter_period`.
        const dataToRender = weeklyPerformanceData;

        if (dataToRender.length === 0) {
            weeklyPerformanceTableBody.innerHTML = `<tr><td colspan="4" class="py-4 px-6 text-center text-gray-500 uppercase">NO HAY DATOS SEMANALES PARA EL PERIODO SELECCIONADO.</td></tr>`;
        } else {
            dataToRender.forEach(data => {
                const row = document.createElement('tr');
                row.className = 'border-b border-gray-200 hover:bg-gray-50';
                row.innerHTML = `
                    <td class="py-4 px-6 font-semibold uppercase">${data.week_label}</td>
                    <td class="py-4 px-6 text-center">${data.clients_acquired}</td>
                    <td class="py-4 px-6 text-center">${data.sales_made}</td>
                    <td class="py-4 px-6 text-right">$${data.revenue_generated.toFixed(2)}</td>
                `;
                weeklyPerformanceTableBody.appendChild(row);
            });
        }
    }

    // Helper para obtener el número de mes desde el nombre (útil para lógica de filtro compleja)
    function getMonthNumber(monthName) {
        const monthNamesMap = {
            'enero': 1, 'febrero': 2, 'marzo': 3, 'abril': 4, 'mayo': 5, 'junio': 6,
            'julio': 7, 'agosto': 8, 'septiembre': 9, 'octubre': 10, 'noviembre': 11, 'diciembre': 12
        };
        // Intenta una coincidencia exacta, si no, usa los primeros 3 caracteres
        const normalizedMonthName = monthName.toLowerCase();
        for (const key in monthNamesMap) {
            if (normalizedMonthName.startsWith(key)) {
                return monthNamesMap[key];
            }
        }
        return null;
    }


    // --- FUNCIONES PARA GRÁFICOS (usando Chart.js) ---

    // Renderiza el gráfico de tendencia de ingresos
    let revenueChartInstance = null; // Mantener una referencia para destruir/actualizar
    function renderRevenueTrendChart() {
        if (!revenueTrendChartCtx) {
            console.error('Contexto del canvas de tendencia de ingresos no encontrado.');
            return;
        }

        if (revenueChartInstance) { // Si el gráfico ya existe, destrúyelo para volver a crearlo
            revenueChartInstance.destroy();
        }

        revenueChartInstance = new Chart(revenueTrendChartCtx, {
            type: 'line',
            data: {
                labels: chartMonthsLabels, // Etiquetas de meses (Abril, Mayo, etc.)
                datasets: [{
                    label: 'Ingresos Generados ($)',
                    data: chartRevenueData, // Datos de ingresos
                    borderColor: 'var(--color-primary)', // Color de la línea (azul oscuro)
                    backgroundColor: 'rgba(7, 22, 45, 0.1)', // Color de fondo del área bajo la línea
                    tension: 0.3, // Suavidad de la línea
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false, // Permite que el gráfico se ajuste al tamaño del contenedor
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Ingresos ($)'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Mes'
                        }
                    }
                },
                plugins: {
                    legend: { display: false } // No mostrar la leyenda de los datasets
                }
            }
        });
    }

    // Renderiza el gráfico de comparación de métricas clave
    let keyMetricsChartInstance = null; // Mantener una referencia para destruir/actualizar
    function renderKeyMetricsComparisonChart() {
        if (!keyMetricsComparisonChartCtx) {
            console.error('Contexto del canvas de comparación de métricas no encontrado.');
            return;
        }

        if (keyMetricsChartInstance) { // Si el gráfico ya existe, destrúyelo
            keyMetricsChartInstance.destroy();
        }

        keyMetricsChartInstance = new Chart(keyMetricsComparisonChartCtx, {
            type: 'bar',
            data: {
                labels: chartKeyMetricsLabels, // Etiquetas de las métricas (Clientes, Ventas, etc.)
                datasets: [{
                    label: 'Valor',
                    data: chartKeyMetricsValues, // Valores de las métricas
                    backgroundColor: [ // Colores de las barras
                        'var(--color-secondary)', 
                        'var(--color-primary)',
                        'var(--color-highlight)',
                        'var(--color-purple)'
                    ],
                    borderColor: [ // Bordes de las barras
                        'var(--color-secondary)',
                        'var(--color-primary)',
                        'var(--color-highlight)',
                        'var(--color-purple)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false, // Permite que el gráfico se ajuste al tamaño del contenedor
                scales: {
                    y: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: { display: false } // No mostrar la leyenda
                }
            }
        });
    }


    // --- INICIALIZACIÓN DE LA PÁGINA ---
    // Esta es la función principal que se ejecuta una vez que el DOM está completamente cargado.

    // 1. Mostrar notificación PHP si existe
    const phpNotificationMessage = "<?php echo addslashes($notification_message); ?>";
    const phpNotificationType = "<?php echo addslashes($notification_type); ?>";
    if (phpNotificationMessage) {
        showCustomNotification(phpNotificationMessage, phpNotificationType);
    }

    // 2. Configurar eventos de la barra lateral (menú móvil)
    if (mobileMenuButton) {
        // Asegúrate de que `toggleSidebar` esté definido en `files/header-manager.js`
        mobileMenuButton.addEventListener('click', typeof toggleSidebar === 'function' ? toggleSidebar : () => {
            console.error('toggleSidebar function not found. Please ensure header-manager.js is loaded and defines it.');
            // Fallback rudimentario si toggleSidebar no está definido
            if (sidebar && sidebarOverlay) {
                sidebar.classList.toggle('-translate-x-full');
                sidebarOverlay.classList.toggle('hidden');
            }
        });
    }

    if (sidebarOverlay) {
        sidebarOverlay.addEventListener('click', () => {
            if (typeof toggleSidebar === 'function') toggleSidebar();
            // No hay paneles deslizantes en esta página que necesiten cerrarse con el overlay principal.
        });
    }
    if (sidebarCloseBtn) {
        if (typeof toggleSidebar === 'function') sidebarCloseBtn.addEventListener('click', toggleSidebar);
    }
    
    // Define `toggleSidebar` si no existe en `header-manager.js` (para evitar errores si no está cargada)
    if (typeof window.toggleSidebar === 'undefined') {
        window.toggleSidebar = function() {
            const sidebarElement = document.getElementById('sidebar');
            const sidebarOverlayElement = document.getElementById('sidebar-overlay');
            if (sidebarElement && sidebarOverlayElement) {
                sidebarElement.classList.toggle('-translate-x-full');
                sidebarOverlayElement.classList.toggle('hidden');
            }
        };
    }

    // 3. Actualizar métricas de resumen al cargar
    updatePerformanceMetricsDisplay();

    // 4. Poblar selectores de filtros de período y renderizar tablas de desglose
    populateMonthYearFilters();
    renderMonthlyPerformance();
    renderWeeklyPerformance();

    // 5. Renderizar gráficos
    renderRevenueTrendChart();
    renderKeyMetricsComparisonChart();


    // 6. Listeners para filtros de período
    if (monthlyPerformanceFilterPeriod) {
        monthlyPerformanceFilterPeriod.addEventListener('change', function() {
            // Cuando el filtro cambia, recargamos la página con el nuevo período
            // En un sistema real, harías una llamada AJAX aquí para obtener los nuevos datos
            // sin recargar la página completa.
            window.location.href = `performance.php?period=${this.value}`;
        });
    }
    if (weeklyPerformanceFilterPeriod) {
        weeklyPerformanceFilterPeriod.addEventListener('change', function() {
            // Cuando el filtro cambia, recargamos la página con el nuevo período
            window.location.href = `performance.php?period=${this.value}`;
        });
    }

    // 7. Listeners para botones de descarga
    if (downloadMonthlyPerformanceBtn) {
        downloadMonthlyPerformanceBtn.addEventListener('click', () => {
            // Al descargar el mensual, usa los datos de `monthlyPerformanceData`
            descargarComoCSV(monthlyPerformanceData, `rendimiento_mensual_${selectedFilterPeriod}.csv`);
            showCustomNotification('Descargando datos mensuales...', 'info');
        });
    }
    if (downloadWeeklyPerformanceBtn) {
        downloadWeeklyPerformanceBtn.addEventListener('click', () => {
            // Al descargar el semanal, usa los datos de `weeklyPerformanceData`
            descargarComoCSV(weeklyPerformanceData, `rendimiento_semanal_${selectedFilterPeriod}.csv`);
            showCustomNotification('Descargando datos semanales...', 'info');
        });
    }

    // 8. Listener para el botón "Añadir Dato" del sidebar (en esta página es solo un placeholder)
    if (addPerformanceEntryBtn) {
        addPerformanceEntryBtn.addEventListener('click', () => {
            showCustomNotification('Esta sección es solo de visualización. Los datos de rendimiento se generan automáticamente en un sistema real.', 'info', 5000);
        });
    }

    // El modal de confirmación solo se usa para la acción de "eliminar" o "realizar acción",
    // en este dashboard de rendimiento no hay acciones de ese tipo directamente en la UI.
    // La función openConfirmActionModal está disponible si la necesitaras en el futuro.
    if (confirmDeleteButton) { // Es el botón interno del modal de confirmación
        confirmDeleteButton.addEventListener('click', function() {
            // Esta lógica se manejaría directamente en la función `openConfirmActionModal`
            // a través del callback que se le pase. No necesita un listener aquí.
        });
    }

    // Se re-renderizan los iconos de Lucide al cargar el DOM
    lucide.createIcons();
    console.log("[performance.php] Página de rendimiento inicializada.");
});

</script>
</body>
</html>