<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

// Solo permitir solicitudes POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

// Obtener y decodificar los datos JSON de la solicitud
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que todos los datos requeridos estén presentes
$required_fields = [
    'business_name', 'phone_whatsapp', 'product_service_description',
    'problem_solved', 'desired_outcome', 'key_benefits', 'communication_tone'
];

foreach ($required_fields as $field) {
    if (!isset($data[$field]) || (is_string($data[$field]) && trim($data[$field]) === '')) {
        http_response_code(400);
        echo json_encode(['error' => "Falta el campo requerido: '{$field}'. Asegúrate de completar todos los datos. " . (isset($data[$field]) ? 'Valor actual: "' . $data[$field] . '"' : 'No seteado')]);
        exit;
    }
}

// Campos opcionales
$website_url = $data['website_url'] ?? '';
$service_zone = $data['service_zone'] ?? '';

// Limpiar la URL de 'http://' o 'https://' para un CTA más limpio
// ¡ESTA ES LA LÓGICA CLAVE PARA LA URL!
if (!empty($website_url)) {
    $website_url = preg_replace('/^https?:\/\//', '', $website_url);
    // Añadir una barra final si la URL no la tiene y no es solo un dominio
    if (strpos($website_url, '.') !== false && substr($website_url, -1) !== '/') {
        // $website_url .= '/'; // Considera añadir esto si quieres que siempre termine en barra
    }
}

// --- PROMPT MAESTRO (v1.0 - Creador de Publicaciones Sociales Bilingüe con Hashtags) ---
// *** IMPORTANTE: Se añadió instrucción a la IA para no incluir http/https en URLs ***
$prompt = "Actúa como un experto en marketing digital y copywriter para negocios locales. Tu tarea es generar publicaciones atractivas para redes sociales que capten la atención y generen interacción, siempre en español y en inglés, incluyendo hashtags relevantes.

--- FILOSOFÍA CLIENT3 ---
- Los posts deben ser concisos y enfocados.
- Deben seguir la estructura de Problema -> Solución -> Servicio.
- Utilizar un tono de comunicación consistente con la marca.
- Incluir un llamado a la acción claro y fácil de seguir.

--- TU TAREA ESPECÍFICA ---
Genera 3 tipos de publicaciones, cada una con su versión en español y en inglés, y con sus respectivos hashtags.

--- DATOS DEL NEGOCIO ---
- Nombre del Negocio: {$data['business_name']}
- Página Web/Perfil Social: {$website_url}
- Teléfono/WhatsApp: {$data['phone_whatsapp']}
- Zona de Servicio: {$service_zone}
- Descripción del Producto/Servicio: {$data['product_service_description']}
- Problema Resuelto: {$data['problem_solved']}
- Deseo del Cliente: {$data['desired_outcome']}
- Beneficios Clave: {$data['key_benefits']}
- Tono de Comunicación: {$data['communication_tone']}

--- ESTRUCTURA DE LAS PUBLICACIONES ---
1.  **Publicación Enfocada en el Problema:**
    -   **Copy:** Un texto corto que agita el problema del cliente, presenta brevemente el servicio como la solución y termina con un CTA.
    -   **Hashtags:** Relevantes al problema, el servicio y la zona (si aplica).
2.  **Publicación Enfocada en la Solución/Deseo:**
    -   **Copy:** Un texto que pinta el resultado ideal que el cliente desea, muestra cómo tu servicio lo logra y termina con un CTA.
    -   **Hashtags:** Relevantes al deseo/solución, el servicio y la zona (si aplica).
3.  **Publicación Enfocada en el Servicio/Beneficios:**
    -   **Copy:** Describe el servicio, lista sus beneficios clave (usando emojis como ✅ o ⭐ si encajan con el tono) y termina con un CTA claro.
    -   **Hashtags:** Relacionados con el servicio, sus beneficios y la zona (si aplica).

--- REGLAS ESTRICTAS PARA LA GENERACIÓN ---
-   **Output Bilingüe:** Para CADA publicación, DEBES proporcionar una versión en 'es' (español) y 'en' (inglés).
-   **Hashtags:** Cada versión (es/en) debe tener su propio array de 5 a 10 hashtags. Los hashtags NO deben incluir espacios y deben ser relevantes. Los hashtags geográficos solo si 'Zona de Servicio' se proporciona.
-   **Concisión:** El copy de cada publicación (es/en) debe ser conciso, ideal para redes sociales (máximo 5-7 líneas).
-   **Llamado a la Acción (CTA):** En cada copy (es/en), el CTA DEBE incluir el 'Teléfono/WhatsApp' {$data['phone_whatsapp']}. Si 'Página Web/Perfil Social' {$website_url} se proporciona, también debe incluirse. El CTA debe ser claro (ej. 'Contáctanos hoy', 'Envíanos un mensaje', 'Visita nuestra web' o 'Visita {$website_url}' - **ASEGÚRATE de NO incluir 'http://' o 'https://' en las URLs en el CTA**).
-   **Tono:** El tono de la publicación debe ser coherente con 'Tono de Comunicación' seleccionado.
-   **Emojis:** Usa emojis de forma profesional y moderada si encajan con el tono (ej. ✨, 🚀, ✅, ⭐).

--- FORMATO DE RESPUESTA REQUERIDO ---
La respuesta DEBE ser un objeto JSON válido con una clave 'posts', que es un array de objetos. Cada objeto en 'posts' debe tener:
- 'type': ('problem', 'solution', 'service')
- 'es_copy': string
- 'es_hashtags': array de strings
- 'en_copy': string
- 'en_hashtags': array de strings
";

// URL de la API de Google Gemini
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

// Inicializar cURL
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

// Manejo de errores de la solicitud cURL o respuesta HTTP
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response' => $response
    ]);
    exit;
}

// Decodificar la respuesta de la IA
$result = json_decode($response, true);

// Extraer el texto generado.
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? null;

// Limpiar el texto de posibles bloques de código Markdown
if ($generated_text) {
    $generated_text = str_replace(['```json', '```'], '', $generated_text);
}

// Intentar decodificar el JSON final.
$final_data = json_decode(trim($generated_text), true);

// Validar el formato del JSON final y su estructura
if ($final_data === null || !isset($final_data['posts']) || !is_array($final_data['posts']) || empty($final_data['posts'])) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o la estructura de datos esperada no está completa/correcta. Intenta de nuevo con tus datos.',
        'raw_ai_response_after_trim' => trim($generated_text),
        'decoded_data_debug' => $final_data
    ]);
    exit;
}

// Si todo es correcto, devolver los datos generados
echo json_encode($final_data);