<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que todos los datos requeridos estén presentes
// prospect_name se ha hecho opcional en el front-end, pero si existe se usará.
$required_fields = [
    'business_name',
    'service_type',
    'prospect_type',
    'contact_context',
    'desired_outcome',
    'communication_tone'
];

foreach ($required_fields as $field) {
    if (!isset($data[$field]) || (is_string($data[$field]) && trim($data[$field]) === '')) {
        http_response_code(400);
        echo json_encode(['error' => "Falta el campo requerido: '{$field}'. Asegúrate de completar todos los datos."]);
        exit;
    }
}

// Obtener el nombre del prospecto, si se proporciona.
$prospect_name = isset($data['prospect_name']) ? trim($data['prospect_name']) : '';

// --- PROMPT MAESTRO (Generador de Mensajes de Primer Contacto - v2.1 con manejo de prospect_name) ---
$prompt = "Actúa como un experto en ventas y comunicación para negocios locales. Tu tarea es generar opciones de mensajes de primer contacto altamente efectivos y persuasivos, adaptados al contexto y al prospecto, siempre con un llamado a la acción claro.

--- FILOSOFÍA CLIENT3 ---
- El primer contacto debe ser relevante y personalizado.
- Debe enfocarse en el prospecto, no solo en vender.
- El objetivo es iniciar una conversación, no cerrar la venta de inmediato.
- Debe ser conciso y fácil de entender.

--- TU TAREA ESPECÍFICA ---
Un usuario necesita mensajes para iniciar contacto con nuevos prospectos. Basado en la siguiente información, genera 3 opciones de mensajes de primer contacto. Cada mensaje debe tener su versión en español y en inglés.

--- DATOS PROPORCIONADOS ---
- Nombre del Negocio: \"" . $data['business_name'] . "\"
- Servicio Principal: \"" . $data['service_type'] . "\"
- Tipo de Prospecto o Problema que podría tener: \"" . $data['prospect_type'] . "\"
- Contexto del Contacto (cómo los encontraste/por qué les escribes): \"" . $data['contact_context'] . "\"
- Resultado Deseado del Mensaje (qué quieres que hagan): \"" . $data['desired_outcome'] . "\"
- Tono de Comunicación Deseado: \"" . $data['communication_tone'] . "\"
";

if (!empty($prospect_name)) {
    $prompt .= "- Nombre Específico del Prospecto: \"" . $prospect_name . "\"\n";
}

$prompt .= "
--- REGLAS ESTRICTAS PARA LA GENERACIÓN ---
- **Output Bilingüe:** Para CADA mensaje, DEBES proporcionar una versión en 'es' (español) y 'en' (inglés).
- **Concisión:** Cada mensaje (es/en) debe ser conciso (máximo 5-7 líneas).
- **Personalización ESTRICTA:** DEBES usar directamente la información proporcionada en 'DATOS PROPORCIONADOS' para construir los mensajes.
- **PROHIBIDO Usar Marcadores de Posición `[...]`:** NUNCA incluyas texto entre corchetes `[...]` en el mensaje generado. SI se te proporcionó un 'Nombre Específico del Prospecto', DEBES usarlo directamente. Si no se te proporcionó, asume que el usuario lo insertará manualmente y deja el mensaje sin un nombre específico al inicio, o usa un saludo general y profesional.
- **Enfoque en el Prospecto:** Empieza el mensaje centrándote en el problema o interés del prospecto, derivado de 'Tipo de Prospecto/Problema' y 'Contexto del Contacto'.
- **Llamado a la Acción (CTA):** Cada mensaje debe terminar con un CTA claro, alineado con el 'Resultado Deseado del Mensaje'.
- **Tono:** El tono de la publicación debe ser coherente con el 'Tono de Comunicación Deseado'.
- **Emojis:** Usa emojis de forma profesional y moderada si encajan con el tono (ej. ✨, 🚀, ✅, ⭐).

--- FORMATO DE RESPUESTA REQUERIDO ---
La respuesta DEBE ser un objeto JSON válido con una clave 'messages', que es un array de 3 objetos. Cada objeto en 'messages' debe tener:
- 'es': string (el mensaje en español)
- 'en': string (el mensaje en inglés)
";

// URL de la API de Google Gemini
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

// Inicializar cURL
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Añadido para seguir redirecciones
curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Añadido para un tiempo límite de 30 segundos
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); // Añadido para un tiempo límite de conexión de 10 segundos
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    // Intentar obtener más detalles del error si la respuesta no es 200
    $error_details = $curl_error ?: ($response ? json_decode($response, true) : 'Respuesta vacía o ilegible de la API.');
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error, // Mensaje de error de cURL
        'raw_response_from_ai' => $response, // Respuesta cruda de la API para depuración
        'details' => $error_details
    ]);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? '';

// Limpiar el texto de posibles bloques de código Markdown
if ($generated_text) {
    $generated_text = str_replace(['```json', '```'], '', $generated_text);
}

// Intentar decodificar el JSON final.
$final_data = json_decode(trim($generated_text), true);

// Validar el formato del JSON final y su estructura
if ($final_data === null || !isset($final_data['messages']) || !is_array($final_data['messages']) || empty($final_data['messages'])) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o la estructura de datos esperada no está completa/correcta. Intenta de nuevo con tus datos.',
        'raw_ai_response_after_trim' => trim($generated_text),
        'decoded_data_debug' => $final_data
    ]);
    exit;
}

// Si todo es correcto, devolver los datos generados
echo json_encode($final_data);
?>