<?php
// db/agenda-delete.php
ob_start();
header('Content-Type: application/json');
include_once 'db_connection.php';

// Leer el cuerpo de la solicitud, ya que el método es DELETE
$data = json_decode(file_get_contents('php://input'), true);
$response = [];

if (!$data || !isset($data['id']) || !isset($data['type'])) {
    // Extraer el prefijo para obtener el ID numérico
    $id_parts = explode('-', $data['id'] ?? '');
    $id = end($id_parts);
    $type = $data['type'] ?? '';

    if (!is_numeric($id) || empty($type)) {
        echo json_encode(['status' => 'error', 'message' => 'ID o tipo de cita no proporcionado o inválido.']);
        exit;
    }
} else {
    // Si los datos vienen en el formato esperado
    $id_parts = explode('-', $data['id'] ?? '');
    $id = end($id_parts);
    $type = $data['type'];
}


try {
    if ($type === 'unica') {
        $sql = "DELETE FROM unique_appointments WHERE id = ?";
        $stmt = $pdo->prepare($sql);
    } elseif ($type === 'recurrente') {
        $sql = "DELETE FROM recurring_appointments WHERE id = ?";
        $stmt = $pdo->prepare($sql);
    } else {
        throw new Exception("Tipo de cita no válido para eliminar.");
    }

    if ($stmt->execute([$id])) {
        if ($stmt->rowCount() > 0) {
            $response = ['status' => 'success', 'message' => 'Cita eliminada con éxito.'];
        } else {
            $response = ['status' => 'error', 'message' => 'No se encontró la cita para eliminar.'];
        }
    } else {
        throw new Exception('Falló la ejecución de la consulta de eliminación.');
    }

} catch (PDOException $e) {
    error_log("Error en agenda-delete.php: " . $e->getMessage());
    $response = ['status' => 'error', 'message' => 'Error de base de datos: ' . $e->getMessage()];
} catch (Exception $e) {
    $response = ['status' => 'error', 'message' => $e->getMessage()];
}

ob_end_clean();
echo json_encode($response);
exit;
?>