<?php
// db/clients-delete.php

// ***** IMPORTANTE: ESTAS LÍNEAS ESTÁN AQUÍ PARA DEPURAR. *****
// UNA VEZ QUE FUNCIONE, CÁMBIALAS A: error_reporting(0); ini_set('display_errors', 0);
error_reporting(E_ALL); // Reporta todos los errores
ini_set('display_errors', 1); // Muestra los errores en la pantalla
// *************************************************************

session_start();
header('Content-Type: application/json');

include_once 'db_connection.php'; // Asegúrate de que esta ruta sea correcta

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en clients-delete.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input) || !isset($input['id'])) {
        error_log("Datos de entrada inválidos o ID de cliente no proporcionado en clients-delete.php.");
        $response['message'] = 'ID de cliente no proporcionado.';
        echo json_encode($response);
        exit();
    }

    $client_id = (int) $input['id'];

    try {
        $pdo->beginTransaction(); // Inicia una transacción

        // Eliminar el cliente
        $stmt = $pdo->prepare("DELETE FROM clients WHERE id = ?");
        $stmt->execute([$client_id]);

        // Si hay una tabla 'client_services', la FOREIGN KEY con ON DELETE CASCADE
        // debería manejar la eliminación de los servicios asociados automáticamente.
        // Si no tienes ON DELETE CASCADE, necesitarías una línea adicional aquí:
        // $stmtDeleteServices = $pdo->prepare("DELETE FROM client_services WHERE client_id = ?");
        // $stmtDeleteServices->execute([$client_id]);

        $pdo->commit(); // Confirma la transacción
        $response['success'] = true;
        $response['message'] = 'Cliente eliminado con éxito.';

    } catch (PDOException $e) {
        $pdo->rollBack(); // Deshace los cambios si hay un error de DB
        error_log("Error al eliminar cliente (PDO): " . $e->getMessage());
        $response['message'] = 'Error de base de datos al eliminar cliente: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack(); // Deshace los cambios en caso de error general
        error_log("Error general al eliminar cliente: " . $e->getMessage());
        $response['message'] = 'Error interno al eliminar cliente: ' . $e->getMessage();
    }
} else {
    error_log("clients-delete.php: Solicitud recibida no es POST. Método: " . $_SERVER['REQUEST_METHOD']);
    $response['message'] = 'Método de solicitud no válido.';
}

echo json_encode($response);
exit(); // Asegurarse de que no haya más salida accidental