<?php
// Incluir la conexión a la base de datos
include_once 'db_connection.php';

// Establecer la cabecera para devolver una respuesta en formato JSON
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: DELETE'); // Permitir el método DELETE

// Leer los datos JSON que envía el JavaScript
$data = json_decode(file_get_contents('php://input'), true);

// Validar que se recibió un ID
if (!isset($data['id']) || empty($data['id'])) {
    echo json_encode(['success' => false, 'message' => 'No se proporcionó el ID de la transacción a eliminar.']);
    exit;
}

$transaction_id = $data['id'];

try {
    // Preparar y ejecutar la consulta SQL para eliminar el registro
    $sql = "DELETE FROM finances WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    
    // Ejecutar la consulta, pasando el ID como parámetro
    $stmt->execute([':id' => $transaction_id]);

    // Verificar si se eliminó alguna fila
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Transacción eliminada correctamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'No se encontró ninguna transacción con el ID proporcionado.']);
    }

} catch (PDOException $e) {
    // Registrar el error para depuración
    error_log("Error en DB al eliminar transacción: " . $e->getMessage());
    // Enviar una respuesta de error genérica
    echo json_encode(['success' => false, 'message' => 'Error en la base de datos al intentar eliminar la transacción.']);
}
?>