<?php
// db/quote-delete.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = [];

try {
    // Decodifica el cuerpo de la solicitud JSON
    $data = json_decode(file_get_contents('php://input'), true);

    // Valida si el JSON es correcto
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Error: JSON inválido recibido.');
    }
    // Valida si el ID fue proporcionado
    if (empty($data['id'])) {
        throw new Exception('ID del estimado no proporcionado para la eliminación.');
    }

    // Valida que el ID sea un entero
    $estimate_id = filter_var($data['id'], FILTER_VALIDATE_INT);
    if ($estimate_id === false) {
        throw new Exception('ID de estimado inválido.');
    }

    // *** CORRECCIÓN APLICADA AQUÍ ***
    // Se cambió "estimates" por "quotes" para que coincida con tu estructura.
    $sql = "DELETE FROM estimates WHERE id = ?";
    $stmt = $pdo->prepare($sql);

    // Ejecuta la consulta de eliminación
    if ($stmt->execute([$estimate_id])) {
        // Verifica si alguna fila fue afectada para confirmar la eliminación
        if ($stmt->rowCount() > 0) {
            $response = ['success' => true, 'message' => 'Estimado eliminado con éxito.'];
        } else {
            $response = ['success' => false, 'message' => 'No se encontró el estimado para eliminar.'];
        }
    } else {
        throw new Exception('Falló la ejecución de la consulta de eliminación.');
    }
} catch (PDOException $e) {
    // Captura errores específicos de la base de datos
    error_log("PDO Error en quote-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'Error de Base de Datos: ' . $e->getMessage()];
} catch (Exception $e) {
    // Captura otros errores generales
    error_log("General Error en quote-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => $e->getMessage()];
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>