<?php
// db/recurring-finances-delete.php
ob_start();
error_reporting(0); // Desactivar errores en producción
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = [];

try {
    $data = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Error: JSON inválido recibido.');
    }
    if (empty($data['id'])) {
        throw new Exception('ID del gasto recurrente no proporcionado para la eliminación.');
    }

    $id = filter_var($data['id'], FILTER_VALIDATE_INT);
    if ($id === false) {
        throw new Exception('ID de gasto recurrente inválido.');
    }

    $sql = "DELETE FROM recurring_finances WHERE id = ?";
    $stmt = $pdo->prepare($sql);

    if ($stmt->execute([$id])) {
        if ($stmt->rowCount() > 0) {
            $response = ['success' => true, 'message' => 'Gasto recurrente eliminado con éxito.'];
        } else {
            throw new Exception('No se encontró el gasto recurrente con ese ID para eliminar.');
        }
    } else {
        throw new Exception('Falló la ejecución de la consulta de eliminación del gasto recurrente.');
    }

} catch (PDOException $e) {
    error_log("PDO Error en recurring-finances-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'Error de Base de Datos: ' . $e->getMessage()];
} catch (Exception $e) {
    error_log("General Error en recurring-finances-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => $e->getMessage()];
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>