<?php
// db/services-read-all.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response_data = ['success' => false, 'data' => []];

try {
    // Seleccionar ID, nombre, precio y categoría de la tabla 'services'
    $stmt = $pdo->query("SELECT id, name, price, category FROM services ORDER BY name ASC");
    $services = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $formatted_services = [];
    foreach ($services as $service) {
        $formatted_services[] = [
            'id' => (int)$service['id'],
            'name' => $service['name'],
            'price' => (float)$service['price'], // Asegurar que el precio es float
            'category' => $service['category']
        ];
    }

    $response_data = ['success' => true, 'data' => $formatted_services];

} catch (PDOException $e) {
    error_log("Error PDO al cargar todos los servicios para quotes: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar servicios: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("Error general al cargar todos los servicios para quotes: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar servicios: ' . $e->getMessage();
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response_data);
exit;
?>