<?php
ob_start(); // Paso 1: AGREGADO para asegurar que NADA se imprima antes.

// Paso 2: Deshabilitar la visualización de errores para asegurar una salida JSON limpia
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php'; // Incluye el archivo de conexión a la base de datos

$response_data = []; // Usaremos una variable temporal para construir la respuesta

try {
    $stmt = $pdo->query("SELECT id, name, price, category, description, show_on_web FROM services ORDER BY name ASC");
    $services = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response_data = ['success' => true, 'services' => $services];
} catch (PDOException $e) {
    error_log("Error PDO al cargar servicios desde la DB: " . $e->getMessage()); // Error para logs, no para la pantalla
    $response_data = ['success' => false, 'message' => 'Error de Base de Datos al cargar servicios: ' . $e->getMessage()];
} catch (Exception $e) {
    error_log("Error general al cargar servicios: " . $e->getMessage()); // Error para logs, no para la pantalla
    $response_data = ['success' => false, 'message' => 'Error inesperado al cargar servicios: ' . $e->getMessage()];
}

ob_end_clean(); // Paso 3: Limpiar el buffer de salida, asegurando que nada ANTES de aquí se envíe

header('Content-Type: application/json'); // Indica que la respuesta será JSON
echo json_encode($response_data); // Enviar la respuesta JSON final
exit;