<?php
// db/upload-profile-photo.php
ob_start();
error_reporting(0); // Desactivar errores en producción
ini_set('display_errors', 0);

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Asumiendo que el tenant_id se obtiene de alguna manera (ej. de la sesión del usuario autenticado)
    // Para este ejemplo, usaremos un ID de prueba; en producción, DEBE SER DINÁMICO Y SEGURO.
    $tenant_id = 1; // ID del inquilino actual

    // Verificar si se subió un archivo
    if (!isset($_FILES['profile_photo']) || $_FILES['profile_photo']['error'] !== UPLOAD_ERR_OK) {
        $response['message'] = 'Error al subir el archivo.';
        if (isset($_FILES['profile_photo']['error'])) {
            switch ($_FILES['profile_photo']['error']) {
                case UPLOAD_ERR_INI_SIZE:
                case UPLOAD_ERR_FORM_SIZE:
                    $response['message'] = 'El archivo es demasiado grande.';
                    break;
                case UPLOAD_ERR_PARTIAL:
                    $response['message'] = 'La subida del archivo fue parcial.';
                    break;
                case UPLOAD_ERR_NO_FILE:
                    $response['message'] = 'No se seleccionó ningún archivo.';
                    break;
                case UPLOAD_ERR_NO_TMP_DIR:
                    $response['message'] = 'Falta una carpeta temporal.';
                    break;
                case UPLOAD_ERR_CANT_WRITE:
                    $response['message'] = 'No se pudo escribir el archivo en el disco.';
                    break;
                case UPLOAD_ERR_EXTENSION:
                    $response['message'] = 'Una extensión de PHP detuvo la subida del archivo.';
                    break;
                default:
                    $response['message'] = 'Error de subida desconocido.';
                    break;
            }
        }
        echo json_encode($response);
        exit;
    }

    $file_tmp_path = $_FILES['profile_photo']['tmp_name'];
    $file_name = $_FILES['profile_photo']['name'];
    $file_size = $_FILES['profile_photo']['size'];
    $file_type = $_FILES['profile_photo']['type'];
    $file_extension = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

    // Validar tipo de archivo
    $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
    if (!in_array($file_extension, $allowed_extensions)) {
        $response['message'] = 'Tipo de archivo no permitido. Solo se aceptan JPG, JPEG, PNG, GIF.';
        echo json_encode($response);
        exit;
    }

    // Validar tamaño de archivo (ej. máximo 2MB)
    if ($file_size > 2 * 1024 * 1024) { // 2 MB
        $response['message'] = 'El archivo es demasiado grande (máximo 2MB).';
        echo json_encode($response);
        exit;
    }

    // Generar un nombre de archivo único para evitar conflictos y adivinar URL
    $new_file_name = uniqid('profile_', true) . '.' . $file_extension;
    
    // Directorio de destino: ../files/uploads/{tenant_id}/profile_photos/
    $upload_base_dir = realpath(__DIR__ . '/../files/uploads/');
    $tenant_upload_dir = $upload_base_dir . '/' . $tenant_id . '/profile_photos/';

    // Asegurarse de que el directorio del inquilino y el de fotos existen
    if (!is_dir($tenant_upload_dir)) {
        mkdir($tenant_upload_dir, 0755, true); // Crear recursivamente si no existe
    }
    
    $dest_path = $tenant_upload_dir . $new_file_name;

    // Mover el archivo subido
    if (move_uploaded_file($file_tmp_path, $dest_path)) {
        $response['success'] = true;
        $response['message'] = 'Foto subida con éxito.';
        // Devolver la URL relativa desde la raíz del sitio web (ej. files/uploads/1/profile_photos/...)
        $response['file_url'] = 'files/uploads/' . $tenant_id . '/profile_photos/' . $new_file_name;
    } else {
        $response['message'] = 'Error al guardar el archivo en el servidor. Verifica los permisos de la carpeta.';
    }

} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>