<?php
// db/user-password-update.php
ob_start();
error_reporting(0); // Cambiar a E_ALL; ini_set('display_errors', 1); para depuración
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en user-password-update.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input) || empty($input['current_password']) || empty($input['new_password'])) {
        $response['message'] = 'Faltan datos obligatorios (contraseña actual y nueva contraseña).';
        echo json_encode($response);
        exit();
    }

    // Asumimos que actualizaremos la contraseña del usuario con ID 1.
    // En un sistema real, el user_id vendría de la sesión del usuario autenticado.
    $user_id = 1; 

    $current_password = $input['current_password'];
    $new_password = $input['new_password'];

    // En un sistema real, aquí verificarías la contraseña actual con password_verify()
    // y hashearías la nueva contraseña con password_hash().
    // Por simplicidad para este ejercicio, solo mostraremos un mensaje.

    // Simulación: Verificar que la nueva contraseña no esté vacía y sea segura
    if (strlen($new_password) < 6) { // Ejemplo de regla de seguridad
        $response['message'] = 'La nueva contraseña debe tener al menos 6 caracteres.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // En un sistema real, aquí se actualizaría la contraseña hasheada en la tabla 'users'
        // Por ahora, solo simulamos el éxito.
        // Ejemplo de lo que se haría:
        // $hashed_new_password = password_hash($new_password, PASSWORD_DEFAULT);
        // $stmt = $pdo->prepare("UPDATE users SET password_hash = ? WHERE id = ?");
        // $stmt->execute([$hashed_new_password, $user_id]);

        $pdo->commit();
        $response['success'] = true;
        $response['message'] = 'Contraseña actualizada con éxito.';

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al actualizar contraseña de usuario: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al actualizar contraseña: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al actualizar contraseña de usuario: " . $e->getMessage());
        $response['message'] = 'Error interno al actualizar contraseña: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>