<?php
// db/user-profile-update.php
ob_start();
error_reporting(0); // Desactivar errores en producción
ini_set('display_errors', 0);

include_once 'db_connection.php';
include_once 'file_helpers.php'; // Incluir el nuevo archivo de helpers

$response = ['success' => false, 'message' => ''];


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en user-profile-update.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input)) {
        $response['message'] = 'Datos de solicitud vacíos o no válidos.';
        echo json_encode($response);
        exit();
    }

    // Asumimos que actualizaremos el perfil del usuario con ID 1.
    // En un sistema real, el user_id y tenant_id vendrían de la sesión del usuario autenticado.
    $user_id = 1; 
    $tenant_id = 1; // ID del inquilino actual (usar variable dinámica en producción)

    $full_name = trim($input['full_name'] ?? '');
    $new_profile_photo_url = trim($input['profile_photo_url'] ?? null); // La nueva URL de la foto

    if (empty($full_name)) {
        $response['message'] = 'El nombre completo es obligatorio.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // 1. Obtener la URL de la foto actual ANTES de la actualización
        $stmt_old_photo = $pdo->prepare("SELECT profile_photo_url FROM user_profiles WHERE user_id = ?");
        $stmt_old_photo->execute([$user_id]);
        $old_profile_photo_url = $stmt_old_photo->fetchColumn();

        // 2. Actualizar el perfil del usuario en la base de datos
        $stmt_update = $pdo->prepare("UPDATE user_profiles SET full_name = ?, profile_photo_url = ? WHERE user_id = ?");
        $stmt_update->execute([$full_name, $new_profile_photo_url, $user_id]);

        $pdo->commit();

        // 3. Eliminar la foto antigua del servidor si la URL ha cambiado y no está vacía
        if (!empty($old_profile_photo_url) && $old_profile_photo_url !== $new_profile_photo_url) {
            deleteFileFromServer($old_profile_photo_url, $tenant_id);
        }

        $response['success'] = true;
        $response['message'] = 'Información personal actualizada con éxito.';

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al actualizar perfil de usuario: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al actualizar perfil: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al actualizar perfil de usuario: " . $e->getMessage());
        $response['message'] = 'Error interno al actualizar perfil: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);
exit();
?>