<?php 
// 1. INCLUIR ARCHIVOS DE CONEXIÓN Y SEGURIDAD
include 'files/guardiankey.php'; 
include 'db/db_connection.php'; // Conexión a la base de datos

// 2. OBTENER DATOS DE LA TABLA website_config
$company_name_from_db = 'Nombre de tu Negocio'; // Valor por defecto
$user_name_from_db = 'Tu Nombre'; // Valor por defecto

try {
    $stmt = $pdo->query("SELECT company_name, contact_name FROM website_config WHERE id = 1 LIMIT 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name_from_db = $config['company_name'] ?? $company_name_from_db;
        $user_name_from_db = $config['contact_name'] ?? $user_name_from_db;
    }
} catch (PDOException $e) {
    // En caso de error, la página usará los valores por defecto sin romperse.
    error_log("Error fetching website_config: " . $e->getMessage());
    // No se usa showToast aquí directamente desde PHP, se manejará en JS si es necesario.
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Asistente De Seguimiento Estratégico | OrozDesign Multimedia</title>
    <meta name="description" content="Gestiona tus prospectos y potenciales clientes con el LocalCRM ToolKit Dashboard de OrozDesign Multimedia.">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
    <script src="files/header-manager.js"></script>
        
    <style>
        /* Estilos específicos para los títulos de los pasos */
        /* H2 general ya tiene text-2xl font-black flex items-center uppercase */
        /* Ajustamos cómo se comportan sus hijos directos */

        .step-header h2 {
            /* Por defecto en móvil, los hacemos una columna */
            flex-direction: column;
            align-items: flex-start; /* Alinea los ítems a la izquierda cuando están en columna */
            text-align: left; /* Asegura que el texto en general se alinee a la izquierda */
        }

        .step-header .step-number {
            /* Contenedor para el icono y PASO 1: */
            font-size: 1.25rem; /* Ajuste para móvil: text-xl */
            font-weight: 900;
            margin-right: 0; /* No margin a la derecha cuando está en columna */
            margin-bottom: 0.25rem; /* Espacio vertical entre "PASO 1:" y el título */
            display: flex;
            align-items: center;
            color: var(--color-secondary);
            flex-shrink: 0;
        }
        .step-header .step-number i {
            margin-right: 0.5rem;
            font-size: 1.5rem; /* Ajuste para icono en móvil */
        }

        .step-header .step-title {
            /* Contenedor para el título principal */
            font-size: 1.4rem; /* Ajuste para móvil, un poco más grande que step-number */
            font-weight: 900;
            color: #1e293b;
            line-height: 1.2;
            text-transform: uppercase;
            text-align: left; /* Asegura que el texto en esta span se alinee a la izquierda */
            width: 100%; /* Toma todo el ancho disponible */
        }

        /* Ajustes para pantallas más grandes (md: y superiores) */
        @media (min-width: 768px) {
            .step-header h2 {
                /* Vuelve a ser fila en desktop */
                flex-direction: row;
                align-items: center; /* Alinea los ítems al centro horizontalmente */
                justify-content: flex-start; /* Alinea todo el h2 al inicio */
                text-align: left;
            }
            .step-header .step-number {
                font-size: 1.5rem; /* O md:text-2xl si usas Tailwind directamente */
                margin-right: 0.5rem; /* Vuelve a tener margen a la derecha */
                margin-bottom: 0; /* Elimina el margen vertical */
            }
            .step-header .step-number i {
                font-size: 1.8rem; /* Tamaño del icono en desktop */
            }
            .step-header .step-title {
                font-size: 1.5rem; /* Vuelve a su tamaño de desktop */
                width: auto; /* Permite que el título ocupe solo el ancho necesario */
            }
        }
    </style>
</head>
<body data-page-title="Asistente De Seguimiento Estratégico"
      data-page-subtitle="Crea Mensajes Para Dar Seguimiento Tras Una Propuesta O Servicio"
      data-page-icon="message-check">

    <div id="toast-container" class="toast-container"></div>
        
<?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="follow-up-message-generator" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">

                    <div class="lg:col-span-3">
                        <form id="follow-up-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <span class="step-number"> <i class="fas fa-building mr-3 text-[var(--color-secondary)]"></i> PASO 1:
                                        </span>
                                        <span class="step-title"> DEFINE TU NEGOCIO Y SERVICIO
                                        </span>
                                    </h2>
                                    <p class="step-subtitle uppercase">Ingresa Los Datos Fundamentales De Tu Empresa.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div>
                                            <label for="user_name" class="block font-bold text-gray-700 mb-2">Tu Nombre:</label>
                                            <input type="text" id="user_name" class="w-full p-3 bg-gray-100 border border-gray-300 rounded-lg" value="<?php echo htmlspecialchars($user_name_from_db); ?>" readonly>
                                        </div>
                                        <div>
                                            <label for="company_name" class="block font-bold text-gray-700 mb-2">Nombre De Tu Negocio:</label>
                                            <input type="text" id="company_name" class="w-full p-3 bg-gray-100 border border-gray-300 rounded-lg" value="<?php echo htmlspecialchars($company_name_from_db); ?>" readonly>
                                        </div>
                                    </div>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div>
                                            <label for="client_name" class="block font-bold text-gray-700 mb-2">Nombre De Tu Cliente:</label>
                                            <input type="text" id="client_name" placeholder="Ej: Juan Pérez" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                        </div>
                                        <div>
                                            <label for="service_type" class="block font-bold text-gray-700 mb-2">Tipo De Servicio Realizado:</label>
                                            <input type="text" id="service_type" placeholder="Ej: Limpieza Profunda De La Cocina" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                        </div>
                                    </div>
                                    <div>
                                        <label for="last_service_date" class="block font-bold text-gray-700 mb-2">Fecha Del Último Servicio:</label>
                                        <input type="date" id="last_service_date" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                    </div>
                                    <div>
                                        <label for="service_detail" class="block font-bold text-gray-700 mb-2">Detalle Opcional Del Servicio (Recordatorio):</label>
                                        <textarea id="service_detail" rows="3" placeholder="Ej: Los azulejos del baño quedaron impecables, el cliente mencionó que le encantó el brillo." class="w-full p-3 bg-white border border-gray-300 rounded-lg"></textarea>
                                    </div>
                                    <div>
                                        <label for="message_type" class="block font-bold text-gray-700 mb-2">Tipo De Mensaje De Seguimiento:</label>
                                        <select id="message_type" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                            <option value="1day">Después De 1 Día (Confirmar Satisfacción)</option>
                                            <option value="3-5days">Después De 3-5 Días (Recordatorio Uutil)</option>
                                            <option value="7-10days">Después De 7-10 Días (Invitar A Próxima Contratación)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <span class="step-number"> <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    </span>
                                    <span class="step-title">
                                        INSTRUCCIONES
                                    </span>
                                </h2>
                                <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-info-circle"></i></span><div><strong class="text-brand-dark">DETALLA TU SERVICIO:</strong> Cuanta más información des sobre el servicio previo, más personalizado será el mensaje.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-calendar-check"></i></span><div><strong class="text-brand-dark">ELIGE EL MOMENTO:</strong> Selecciona el tipo de seguimiento adecuado al tiempo transcurrido desde el servicio.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-robot"></i></span><div><strong class="text-brand-dark">GENERA Y COPIA:</strong> Nuestra IA te dará mensajes listos para usar y un consejo estratégico.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-chart-line"></i></span><div><strong class="text-brand-dark">FIDELIZA TUS CLIENTES:</strong> Un buen seguimiento aumenta la satisfacción y las recompras.</div></li>
                            </ul>
                        </div>
                    </div>

                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                            <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <span class="step-number"> <i class="fas fa-paper-plane mr-3 text-[var(--color-secondary)]"></i>
                                    PASO 2:
                                </span>
                                <span class="step-title">
                                    GENERAR MENSAJES
                                </span>
                            </h2>
                            <p class="step-subtitle uppercase">Crea mensajes de seguimiento estratégicos para tus clientes.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                        <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Basado en los detalles del servicio y el momento, <strong class="font-black">CLIENT3 IA</strong>, generará <b>mensajes de seguimiento personalizados</b> y un consejo estratégico para ayudarte a mantener a tus clientes comprometidos y listos para futuras contrataciones.</p>
                            <button id="generateBtn" type="submit" form="follow-up-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">Genera Mensajes De Seguimiento</span>
                                <div id="loader-container" class="hidden ml-3"></div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inicialización del Toast desde URL parámetros (solo aquí, no en header-manager.js)
    const urlParams = new URLSearchParams(window.location.search);
    const notificationType = urlParams.get('notification_type');
    const notificationMessage = urlParams.get('notification_message');

    if (notificationType && notificationMessage) {
        if (typeof showToast === 'function') {
            showToast(notificationMessage, notificationType);
        } else {
            console.error("showToast function is not defined. Toast notification might not display.");
        }
    }

    lucide.createIcons();

    // --- Lógica del Video Player ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => showToast("Error al reproducir video: " + e.message, 'error')); // Replaced console.error
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }

    // --- Lógica del Generador ---
    const form = document.getElementById('follow-up-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Generando Mensajes De Seguimiento...';
        loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>';
        loaderContainer.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        resultContainer.style.opacity = '0'; 

        const formData = {
            user_name: document.getElementById('user_name').value,
            company_name: document.getElementById('company_name').value,
            client_name: document.getElementById('client_name').value,
            service_type: document.getElementById('service_type').value,
            last_service_date: document.getElementById('last_service_date').value,
            service_detail: document.getElementById('service_detail').value,
            message_type: document.getElementById('message_type').value
        };

        try {
            const response = await fetch('api/API-Asistente-De-Seguimiento-Estrategico.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || `El servidor respondió con un error ${response.status}.`);
            }

            const data = await response.json();
            if(data.error) {
                throw new Error(data.error);
            }
            displayResult(data);

        } catch (error) {
            // console.error("Error:", error); // Replaced
            let errorMessage = "No se pudieron generar los mensajes. Por favor, revisa los datos e inténtalo de nuevo.";

            try {
                const jsonStartIndex = error.message.indexOf('{');
                if (jsonStartIndex !== -1) {
                    const errorJsonString = error.message.substring(jsonStartIndex);
                    const errorDetails = JSON.parse(errorJsonString);
                    if (errorDetails.error && errorDetails.error.code === 503) {
                        errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                    } else {
                        errorMessage += ` Detalles: ${error.message}`;
                    }
                } else {
                    errorMessage += ` Detalles: ${error.message}`;
                }
            } catch (parseError) {
                errorMessage += ` Detalles: ${error.message}`;
            }

            resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
            resultContainer.style.opacity = '1';
            showToast(errorMessage, 'error'); // Added toast
        } finally {
            btnText.textContent = 'Genera Mensajes De Seguimiento';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.innerHTML = `
            <div class="ai-response p-6 md:p-8 rounded-xl shadow-md space-y-8">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="result-card-container">
                        <h3 class="text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-comment-dots mr-2 text-[var(--color-primary)]"></i>Mensaje En Español</h3>
                        <div class="message-box bg-gray-50 p-4 rounded-lg border border-gray-200 shadow-sm">${data.spanish_message.replace(/\n/g, '<br>')}</div>
                        <div class="copy-btn-wrapper mt-3">
                            <button class="copy-btn bg-[var(--color-highlight)] text-brand-dark px-3 py-1 rounded-md text-sm hover:opacity-90 transition-opacity" data-copytarget-text="${encodeURIComponent(data.spanish_message)}">
                                <i class="fas fa-copy"></i><span class="copy-text">COPIAR MENSAJE</span>
                            </button>
                        </div>
                    </div>
                    <div class="result-card-container">
                        <h3 class="text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-message mr-2 text-[var(--color-primary)]"></i>Mensaje En Inglés</h3>
                        <div class="message-box bg-gray-50 p-4 rounded-lg border border-gray-200 shadow-sm">${data.english_message.replace(/\n/g, '<br>')}</div>
                        <div class="copy-btn-wrapper mt-3">
                            <button class="copy-btn bg-[var(--color-secondary)] text-white px-3 py-1 rounded-md text-sm hover:opacity-90 transition-opacity" data-copytarget-text="${encodeURIComponent(data.english_message)}">
                                <i class="fas fa-copy"></i><span class="copy-text">COPIAR MENSAJE</span>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="result-card-container mt-8">
                    <h3 class="text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-lightbulb mr-2 text-[var(--color-highlight)]"></i>Consejo A Tener En Cuenta</h3>
                    <div class="tip-box bg-gray-50 p-4 rounded-lg border border-gray-200 shadow-sm flex items-start">
                        <i class="fas fa-lightbulb text-[var(--color-highlight)] mr-3 text-lg"></i>
                        <div class="text-gray-700">${data.tip}</div>
                    </div>
                </div>
            </div>`;
        setTimeout(() => { resultContainer.style.opacity = '1'; resultContainer.style.transform = 'scale(1)'; }, 100);

        // Add event listeners for new copy buttons
        resultContainer.querySelectorAll('.copy-btn').forEach(button => {
            button.addEventListener('click', function() {
                const textToCopy = decodeURIComponent(this.dataset.copytargetText);
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const copyTextSpan = this.querySelector('.copy-text');
                    const originalText = copyTextSpan.textContent;
                    const originalIconClass = this.querySelector('i').className;

                    copyTextSpan.textContent = 'Copiado!';
                    this.querySelector('i').className = 'fas fa-check';
                    showToast('Mensaje copiado al portapapeles.', 'success'); // Added toast

                    setTimeout(() => {
                        copyTextSpan.textContent = originalText;
                        this.querySelector('i').className = originalIconClass;
                    }, 2000);
                }).catch(err => {
                    console.error('Error al copiar:', err);
                    showToast('No se pudo copiar el texto.', 'error'); // Replaced alert
                });
            });
        });
    }

    // Inicializa el header y el reproductor de video (código de header-manager.js)
    // Este bloque de código está duplicado o es redundante si header-manager.js ya lo maneja
    // Lo comento aquí para evitar duplicación de lógica de UI Header y Lucide icons.
    /*
    const pageTitleElement = document.getElementById('page-title');
    const pageSubtitleElement = document.getElementById('page-subtitle');
    if (pageTitleElement && pageSubtitleElement) {
        const body = document.body;
        const iconClass = body.getAttribute('data-page-icon');
        const iconHTML = iconClass ? `<i data-lucide="${iconClass}" class="w-7 h-7"></i>` : '';
        pageTitleElement.innerHTML = `${iconHTML} ${body.getAttribute('data-page-title') || 'Dashboard'}`;
        pageSubtitleElement.textContent = body.getAttribute('data-page-subtitle') || 'Gestión General';
        if(iconHTML) lucide.createIcons();
    }
    */
});
</script>

</body>
</html>