<?php
// 1. INCLUIR ARCHIVOS DE CONEXIÓN Y SEGURIDAD
include 'files/guardiankey.php'; 
include 'db/db_connection.php'; // Conexión a la base de datos

// 2. OBTENER DATOS DE LA TABLA website_config
$company_name_from_db = ''; // Valor por defecto

try {
    $stmt = $pdo->query("SELECT company_name FROM website_config WHERE id = 1 LIMIT 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name_from_db = $config['company_name'] ?? $company_name_from_db;
    }
} catch (PDOException $e) {
    // En caso de error, la página usará el valor por defecto sin romperse.
    error_log("Error fetching website_config: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Traductor Inteligente de Textos de Marketing</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">

    <style>
        /* Estilos específicos para los títulos de los pasos (copiados de archivos anteriores para consistencia) */
        .step-header h2 {
            flex-direction: column;
            align-items: flex-start;
            justify-content: flex-start;
            text-align: left;
        }

        .step-header .step-number {
            font-size: 1.25rem;
            font-weight: 900;
            margin-right: 0;
            margin-bottom: 0.25rem;
            display: flex;
            align-items: center;
            color: var(--color-secondary);
            flex-shrink: 0;
            text-align: left;
        }
        .step-header .step-number i {
            margin-right: 0.5rem;
            font-size: 1.5rem;
        }

        .step-header .step-title {
            font-size: 1.4rem;
            font-weight: 900;
            color: #1e293b;
            line-height: 1.2;
            text-transform: uppercase;
            text-align: left;
            width: 100%;
        }

        @media (min-width: 768px) {
            .step-header h2 {
                flex-direction: row;
                align-items: center;
                justify-content: flex-start;
                text-align: left;
            }
            .step-header .step-number {
                font-size: 1.5rem;
                margin-right: 0.5rem;
                margin-bottom: 0;
                text-align: left;
            }
            .step-header .step-number i {
                font-size: 1.8rem;
            }
            .step-header .step-title {
                font-size: 1.5rem;
                width: auto;
                text-align: left;
            }
        }
    </style>
</head>
<body data-page-title="Traductor Inteligente de Textos"
      data-page-subtitle="Traduce Cualquier Texto de Marketing O Ventas Al Inglés Con Estrategia"
      data-page-icon="language">

    <div id="toast-container" class="toast-container"></div>
        
    <?php include 'files/gtm-body.php'; ?>
        
<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="translator-tool" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">
                    <div class="lg:col-span-3">
                        <form id="translator-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <span class="step-number"> <i class="fas fa-language mr-3 text-[var(--color-secondary)]"></i>
                                            PASO 1:
                                        </span>
                                        <span class="step-title"> PEGA TU TEXTO
                                        </span>
                                    </h2>
                                    <p class="step-subtitle uppercase">Introduce cualquier texto de marketing o ventas en español para traducir.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div>
                                        <label for="ad_text_es" class="block font-bold text-gray-700 mb-2">Tu Texto En Español</label>
                                        <textarea id="ad_text_es" placeholder="Escribe o pega aquí tu mensaje, email, publicación o anuncio..." class="w-full p-3 bg-white border border-gray-300 rounded-lg" rows="8" required></textarea>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <span class="step-number"> <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    </span>
                                    <span class="step-title">
                                        INSTRUCCIONES
                                    </span>
                                </h2>
                                <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-edit"></i></span><div><strong class="text-brand-dark">Pega Texto Completo:</strong> Introduce el mensaje completo para una traducción contextualizada.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-cogs"></i></span><div><strong class="text-brand-dark">Traduce con Estrategia:</strong> La IA optimizará tu texto para el mercado inglés.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-lightbulb"></i></span><div><strong class="text-brand-dark">Notas Inteligentes:</strong> Recibirás consejos para maximizar el impacto de tu traducción.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-copy"></i></span><div><strong class="text-brand-dark">Copia y Pega:</strong> Utiliza la traducción directamente en tus comunicaciones.</div></li>
                            </ul>
                        </div>
                    </div>

                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                            <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <span class="step-number"> <i class="fas fa-spell-check mr-3 text-[var(--color-secondary)]"></i>
                                    PASO 2:
                                </span>
                                <span class="step-title">
                                    TRADUCIR CON ESTRATEGIA
                                </span>
                            </h2>
                            <p class="step-subtitle uppercase">Obtén una versión optimizada de tu texto en inglés con notas inteligentes.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                        <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">La <strong class="font-black">CLIENT3 IA</strong> no solo traducirá tu texto, sino que lo adaptará para captar la atención de tu audiencia en inglés. Recibirás una traducción estratégica y notas clave para su implementación.</p>
                            <button id="generateBtn" type="submit" form="translator-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">TRADUCIR TEXTOS CON ESTRATEGIA</span>
                                <div id="loader-container" class="hidden ml-3"></div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inicialización del Toast desde URL parámetros (solo aquí, no en header-manager.js)
    const urlParams = new URLSearchParams(window.location.search);
    const notificationType = urlParams.get('notification_type');
    const notificationMessage = urlParams.get('notification_message');

    if (notificationType && notificationMessage) {
        if (typeof showToast === 'function') {
            showToast(notificationMessage, notificationType);
        } else {
            console.error("showToast function is not defined. Toast notification might not display.");
        }
    }

    lucide.createIcons();

    // --- Lógica del Video Player (si aplica) ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => showToast("Error al reproducir video: " + e.message, 'error')); // Replaced console.error
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }

    // --- Lógica del Generador ---
    const form = document.getElementById('translator-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Traduciendo Textos Con Estrategia...';
        loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>';
        loaderContainer.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        resultContainer.style.opacity = '0'; // Reinicia la opacidad para la animación

        const formData = {
            ad_text_es: document.getElementById('ad_text_es').value,
        };

        try {
            const response = await fetch('api/API-Traductor-Al-Ingles-Inteligente.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || `El servidor respondió con un error ${response.status}.`);
            }

            const data = await response.json();
            if(data.error) {
                throw new Error(data.error);
            }
            displayResult(data);

        } catch (error) {
            let errorMessage = "No se pudo generar la traducción. Por favor, revisa el texto e inténtalo de nuevo.";

            try {
                const jsonStartIndex = error.message.indexOf('{');
                if (jsonStartIndex !== -1) {
                    const errorJsonString = error.message.substring(jsonStartIndex);
                    const errorDetails = JSON.parse(errorJsonString);
                    if (errorDetails.error && errorDetails.error.code === 503) {
                        errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                    } else {
                        errorMessage += ` Detalles: ${error.message}`;
                    }
                } else {
                    errorMessage += ` Detalles: ${error.message}`;
                }
            } catch (parseError) {
                errorMessage += ` Detalles: ${error.message}`;
            }

            resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
            resultContainer.style.opacity = '1'; // Mostrar el error inmediatamente
            showToast(errorMessage, 'error'); // Added toast
        } finally {
            btnText.textContent = 'TRADUCIR TEXTOS CON ESTRATEGIA';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.innerHTML = `
            <div class="ai-response p-6 md:p-8 rounded-xl shadow-md space-y-8">
                <div>
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-flag-usa mr-3 text-[var(--color-primary)]"></i>VERSión Estratégica En Inglés</h3>
                    <div class="relative mt-4">
                        <textarea readonly class="w-full h-64 p-4 bg-gray-100 text-gray-800 font-medium rounded-lg resize-none leading-relaxed text-lg border border-gray-300">${data.traduccion}</textarea>
                        <button class="copy-btn-assistant absolute bottom-4 right-4 bg-[var(--color-secondary)] text-white font-bold text-sm py-2 px-4 rounded-lg hover:opacity-90" data-copy-text="${encodeURIComponent(data.traduccion)}"><i class="fas fa-copy mr-2"></i>Copiar</button>
                    </div>
                </div>

                <div class="border-t border-gray-200 pt-8">
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-lightbulb mr-3 text-[var(--color-highlight)]"></i>NOTAS DEL TRADUCTOR INTELIGENTE</h3>
                    <ul class="action-plan-list mt-4 space-y-3">
                        ${data.notas.map(n => `
                            <li class="action-plan-item bg-gray-50 p-3 rounded-md border border-gray-200 shadow-sm flex items-start">
                                <span class="icon-wrapper mt-1 mr-3"><i class="fas fa-check-circle text-[var(--color-highlight)]"></i></span>
                                <div class="flex-1 text-gray-700">${n}</div>
                            </li>
                        `).join('')}
                    </ul>
                </div>
            </div>
        `;
        setTimeout(() => { resultContainer.style.opacity = '1'; resultContainer.style.transform = 'scale(1)'; }, 100);

        // Listener para los botones de copiar
        resultContainer.addEventListener('click', function(e) {
            const button = e.target.closest('.copy-btn-assistant');
            if (button) {
                const textToCopy = decodeURIComponent(button.dataset.copyText);
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const originalContent = button.innerHTML;
                    button.innerHTML = '<i class="fas fa-check"></i> Copiado';
                    button.classList.add('copied');
                    showToast('Texto copiado al portapapeles.', 'success'); // Added toast
                    setTimeout(() => {
                        button.innerHTML = originalContent;
                        button.classList.remove('copied');
                    }, 2000);
                }).catch(err => {
                    console.error('Error al copiar el texto: ', err);
                    showToast('Error al copiar el texto.', 'error'); // Added toast
                });
            }
        });
    }
});
</script>
</body>
</html>