<?php
// ==========================================================
// ARCHIVO: login.php (Tu nuevo punto de entrada, antes tu "index.php" propuesto)
// Propósito: Punto de entrada para el recurso, muestra el formulario de acceso
//            o redirige al contenido si el acceso es concedido.
// ==========================================================

// ¡IMPORTANTE! Define la ID numérica única para este recurso.
// Esta ID DEBE COINCIDIR con la ID del producto en tu tabla 'products' de la base de datos.
// Por ejemplo, si "CRM Local Toolkit" tiene ID 1 en tu DB, pon $id_producto_recurso = 1;
$id_producto_recurso = 1; // <--- ¡VERIFICA Y AJUSTA ESTA ID!

// Define el nombre del archivo del contenido real del recurso (tu dashboard).
// Este es el archivo al que se redirigirá si el acceso es exitoso.
$archivo_contenido = 'dashboardKLSMPN3721.php';

// Incluye la lógica de acceso.
// access.php manejará el login, la verificación de acceso y la redirección.
// También establecerá las variables $error_mensaje, $usuario_logueado_general,
// $acceso_concedido_al_recurso, $nombre_producto_actual y $nombre_usuario.
include 'access.php';

// Si la ejecución llega a este punto, significa que el usuario NO tiene acceso
// (o no ha intentado loguearse aún), por lo que se debe mostrar el formulario de login.
// El mensaje de error (si existe) ya viene de access.php.

// Adaptación del título para que "ACCESO EBOOK:" tenga el color primario y el resto el secundario
$titulo_completo_para_mostrar = htmlspecialchars(strtoupper($nombre_producto_actual));
$parte1_titulo = 'ACCESO';
$parte2_titulo = '';

// Si el nombre del producto empieza con "EBOOK:", lo separamos
if (strpos($titulo_completo_para_mostrar, 'EBOOK:') === 0) {
    $parte1_titulo .= ' EBOOK:';
    $parte2_titulo = substr($titulo_completo_para_mostrar, strlen('EBOOK:'));
} else {
    // Si no es un "EBOOK:", el resto del título va en la parte2
    $parte2_titulo = $titulo_completo_para_mostrar;
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso a <?php echo htmlspecialchars($nombre_producto_actual); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style> body { font-family: 'Barlow', sans-serif; } </style>
</head>
<body class="bg-[#07162d]">

    <div class="container mx-auto p-4 flex min-h-screen items-center justify-center">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-0 max-w-5xl rounded-2xl shadow-2xl overflow-hidden">
            <div class="hidden md:block">
                <img src="img/Portada.jpg" alt="Portada Recurso" class="w-full h-full object-contain">
            </div>
            <div class="bg-white p-8 md:p-12 flex flex-col justify-center">
                <header class="text-center mb-6">
                    <img src="img/LogoPlataformaNegro.png" alt="Logo Recurso" class="mx-auto h-20 w-auto mb-4">
                    <h1 class="text-3xl font-black">
                        <span class="text-[#07162d]"><?php echo $parte1_titulo; ?></span><span class="text-[#9e1428]"><?php echo $parte2_titulo; ?></span></h1>
                    <?php if ($usuario_logueado_general && !$acceso_concedido_al_recurso && !empty($error_mensaje)): ?>
                        <p class="text-red-600 mt-2 font-semibold">¡Hola, <?php echo htmlspecialchars($nombre_usuario); ?>! <?php echo htmlspecialchars($error_mensaje); ?></p>
                    <?php else: ?>
                        <p class="text-gray-600 mt-2">INGRESA PARA ADMINISTRAR TU NEGOCIO</p>
                    <?php endif; ?>
                </header>

                <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" class="space-y-6">
                    <div>
                        <div class="relative"><span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fas fa-envelope text-gray-400"></i></span><input type="email" id="email" name="email" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-[#ffc857] focus:border-[#ffc857]" placeholder="Tu Correo Electrónico" required></div>
                    </div>
                    <div>
                        <div class="relative"><span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fas fa-lock text-gray-400"></i></span><input type="password" id="password" name="password" class="w-full pl-10 pr-10 py-3 border border-gray-300 rounded-lg focus:ring-[#ffc857] focus:border-[#ffc857]" placeholder="Contraseña" required><span class="absolute inset-y-0 right-0 flex items-center pr-3 cursor-pointer" id="togglePassword"><i class="fas fa-eye text-gray-400" id="eyeIcon"></i></span></div>
                    </div>

                    <?php if (!empty($error_mensaje)): ?>
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg relative text-center" role="alert"><span><?php echo $error_mensaje; ?></span></div>
                    <?php endif; ?>

                    <button type="submit" class="w-full bg-[#07162d] text-white font-bold py-3 px-8 rounded-lg hover:bg-opacity-90 transition-opacity shadow-lg text-lg">ACCEDER AL RECURSO</button>
                </form>

                <?php include 'files/footer.php'; ?>
            </div>
        </div>
    </div>

    <script>
        const togglePassword = document.querySelector('#togglePassword');
        if (togglePassword) {
            const passwordInput = document.querySelector('#password');
            const eyeIcon = document.querySelector('#eyeIcon');
            togglePassword.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                eyeIcon.classList.toggle('fa-eye');
                eyeIcon.classList.toggle('fa-eye-slash');
            });
        }
    </script>
</body>
</html>