<?php
// menu.php

// Incluir el archivo de conexion a la base de datos
include_once 'db/db_connection.php';

// Variables para almacenar los datos del usuario y del negocio
$userFullName = "Nombre de Usuario";
$userProfilePhoto = "https://placehold.co/96x96/cccccc/333333?text=U"; // Placeholder
$businessName = "Nombre del Negocio";

try {
    // Obtener datos del perfil del usuario (asumiendo user_id = 1)
    $stmt_user = $pdo->prepare("SELECT full_name, profile_photo_url FROM user_profiles WHERE user_id = 1");
    $stmt_user->execute();
    $user_profile_data = $stmt_user->fetch(PDO::FETCH_ASSOC);

    if ($user_profile_data) {
        $userFullName = htmlspecialchars($user_profile_data['full_name'] ?? 'Usuario Desconocido');
        if (!empty($user_profile_data['profile_photo_url'])) {
            $userProfilePhoto = htmlspecialchars($user_profile_data['profile_photo_url']);
        }
    }

    // Obtener el nombre del negocio desde la configuracin del sitio web (asumiendo id = 1)
    $stmt_business = $pdo->prepare("SELECT company_name FROM website_config WHERE id = 1");
    $stmt_business->execute();
    $business_config_data = $stmt_business->fetch(PDO::FETCH_ASSOC);

    if ($business_config_data) {
        $businessName = htmlspecialchars($business_config_data['company_name'] ?? 'Mi Negocio');
    }

} catch (PDOException $e) {
    // Logear el error pero no mostrarlo al usuario final para mantener la interfaz limpia
    error_log("Error PDO al cargar datos en menu.php: " . $e->getMessage());
    // Puedes dejar los placeholders si falla la DB
} catch (Exception $e) {
    error_log("Error general al cargar datos en menu.php: " . $e->getMessage());
}


// Obtiene el nombre del archivo actual para saber qu enlace resaltar
$paginaActual = basename($_SERVER['PHP_SELF']);
?>

<aside id="sidebar" class="bg-[var(--color-primary)] text-[var(--color-text-light)] w-full md:w-64 absolute inset-y-0 left-0 transform -translate-x-full md:relative md:translate-x-0 transition-transform duration-300 ease-in-out z-40 flex flex-col shadow-2xl md:rounded-r-xl">
    <div class="text-center py-6 px-4 border-b border-gray-700/50">
        <img src="img/LogoPlataformaBlanco.png" alt="Logotipo" class="h-12 w-auto mx-auto" onerror="this.style.display='none'">
        <span class="inline-block mt-3 px-3 py-1 text-xs font-bold leading-none text-yellow-800 bg-yellow-200 rounded-full">Versi&oacute;n Profesional</span>
    </div>

    <div class="py-6 border-b border-gray-700/50 text-center px-4">
        <div class="relative inline-block">
            <img class="w-24 h-24 rounded-full mx-auto border-4 border-[var(--color-highlight)]" src="<?php echo $userProfilePhoto; ?>" alt="Avatar de usuario">
            <span class="absolute bottom-1 right-1 block h-4 w-4 rounded-full bg-green-400 border-2 border-[var(--color-primary)]"></span>
        </div>
        <h3 class="font-bold text-xl mt-3"><?php echo $userFullName; ?></h3>
        <p class="text-sm text-gray-400"><?php echo $businessName; ?></p>
    </div>

    <nav class="flex-1 space-y-2 p-2 overflow-y-auto">
        <a href="start.php" data-section="inicio" class="nav-link flex items-center p-3 rounded-lg  transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'start.php') { echo 'active-button'; } ?>">
            <i data-lucide="layout-dashboard" class="w-5 h-5 mr-3"></i> INICIO
        </a>
        <a href="leads.php" data-section="prospectos" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'leads.php') { echo 'active-button'; } ?>">
            <i data-lucide="user-plus" class="w-5 h-5 mr-3"></i> PROSPECTOS
        </a>
        <a href="clients.php" data-section="clientes" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'clients.php') { echo 'active-button'; } ?>">
            <i data-lucide="users" class="w-5 h-5 mr-3"></i> CLIENTES
        </a>
        <a href="services.php" data-section="servicios" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'services.php') { echo 'active-button'; } ?>">
            <i data-lucide="briefcase" class="w-5 h-5 mr-3"></i> SERVICIOS
        </a>
        <a href="agenda.php" data-section="calendario" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'agenda.php') { echo 'active-button'; } ?>">
            <i data-lucide="calendar" class="w-5 h-5 mr-3"></i> CALENDARIO
        </a>
        <a href="finances.php" data-section="finanzas" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'finances.php') { echo 'active-button'; } ?>">
            <i data-lucide="trending-up" class="w-5 h-5 mr-3"></i> FINANZAS
        </a>
        <a href="invoices.php" data-section="facturas" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'invoices.php') { echo 'active-button'; } ?>">
            <i data-lucide="receipt" class="w-5 h-5 mr-3"></i> FACTURAS
        </a>
        <a href="quotes.php" data-section="cotizaciones" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'quotes.php') { echo 'active-button'; } ?>">
            <i data-lucide="file-text" class="w-5 h-5 mr-3"></i> COTIZACIONES
        </a>
        <a href="performance.php" data-section="rendimiento" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'performance.php') { echo 'active-button'; } ?>">
            <i data-lucide="bar-chart-2" class="w-5 h-5 mr-3"></i> RENDIMIENTO
        </a>
        <a href="website.php" data-section="pagina-web" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'website.php') { echo 'active-button'; } ?>">
            <i data-lucide="globe" class="w-5 h-5 mr-3"></i> PAGINA WEB
        </a>
        <a href="ia-marketing.php" data-section="herramientas-ia" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'ia-tools.php') { echo 'active-button'; } ?>">
            <i data-lucide="cpu" class="w-5 h-5 mr-3"></i> IA MARKETING
        </a>
        <a href="academy.php" data-section="academia" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'academy.php') { echo 'active-button'; } ?>">
            <i data-lucide="graduation-cap" class="w-5 h-5 mr-3"></i> ACADEMIA PUBLICITARIA
        </a>
        <a href="promote.php" data-section="promociona" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'promote.php') { echo 'active-button'; } ?>">
            <i data-lucide="rocket" class="w-5 h-5 mr-3"></i> PROMOCIONATE
        </a>
        <a href="account.php" data-section="cuenta" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'account.php') { echo 'active-button'; } ?>">
            <i data-lucide="user-cog" class="w-5 h-5 mr-3"></i> TU CUENTA
        </a>

        <?php include 'ads.php'; ?>

        <button class="w-full flex items-center p-3 rounded-lg bg-red-700 hover:bg-red-800 text-white transition-colors duration-200 uppercase font-bold">
            <i data-lucide="log-out" class="w-5 h-5 mr-3"></i>
            Cerrar Sesi&oacute;n
        </button>
         
        <?php include 'files/footer.php'; ?>

         </nav>
       <div class="mt-auto p-4 border-t border-gray-700/50"> </div>
</aside>