<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Generador De Respuestas Para Grupos</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
</head>
<body data-page-title="Generador De Respuestas Para Grupos"
      data-page-subtitle="Crea Respuestas Que Ayudan Y Convierten En Grupos Sin Vender Directamente"
      data-page-icon="users">

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="group-response-generator" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">

                    <div class="lg:col-span-3">
                        <form id="group-response-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <i class="fas fa-bullhorn mr-3 text-[var(--color-secondary)]"></i>
                                        <span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> DEFINE EL CONTEXTO
                                    </h2>
                                    <p class="step-subtitle uppercase">Ingresa los detalles de la publicación y tu negocio.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div>
                                        <label for="group_post_content" class="block font-bold text-gray-700 mb-2">Contenido Del Post/Comentario En El Grupo</label>
                                        <textarea id="group_post_content" placeholder="Ej: Alguien publicó: 'Mi jardín está lleno de maleza y no tengo tiempo para arreglarlo. ¿Algún consejo?'" class="w-full p-3 bg-white border border-gray-300 rounded-lg" rows="5" required></textarea>
                                    </div>
                                    <div>
                                        <label for="user_service" class="block font-bold text-gray-700 mb-2">Tu Servicio Principal</label>
                                        <input type="text" id="user_service" placeholder="Ej: Servicios de jardinería profesional" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                    </div>
                                    <div>
                                        <label for="communication_tone" class="block font-bold text-gray-700 mb-2">Tono De Comunicación Deseado</label>
                                        <select id="communication_tone" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                            <option value="">Selecciona un tono</option>
                                            <option value="Amigable">Amigable</option>
                                            <option value="Experto">Experto</option>
                                            <option value="Empático">Empático</option>
                                            <option value="Directo pero amable">Directo pero amable</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    INSTRUCCIONES
                                </h2>
                              <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-users"></i></span><div><strong class="text-brand-dark">Conoce Tu Grupo:</strong> Ingresa el post tal cual lo viste.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-hand-holding-heart"></i></span><div><strong class="text-brand-dark">Enfócate en Ayudar:</strong> La IA generará valor sin vender directamente.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-comments"></i></span><div><strong class="text-brand-dark">Invita al Privado:</strong> La meta es que el interesado te contacte por mensaje privado.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-copy"></i></span><div><strong class="text-brand-dark">Copia y Adapta:</strong> Usa la respuesta como base para tu comentario.</div></li>
                            </ul>
                        </div>
                    </div>

                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                             <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <i class="fas fa-robot mr-3 text-[var(--color-secondary)]"></i>
                                <span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> GENERAR RESPUESTA
                            </h2>
                            <p class="step-subtitle uppercase">Crea respuestas sutiles y efectivas para grupos.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                         <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Basado en el contenido del post y tu servicio, <strong class="font-black">CLIENT3 IA</strong>, generará una <b>respuesta estratégica para grupos</b>, diseñada para empatizar, ofrecer valor y motivar a los interesados a escribirte por mensaje privado.</p>
                            <button id="generateBtn" type="submit" form="group-response-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">GENERAR RESPUESTA</span>
                                <div id="loader-container" class="hidden ml-3"></div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();

    // --- Lógica del Video Player ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => console.error("Error al reproducir video:", e));
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }

    // --- Lógica del Generador ---
    const form = document.getElementById('group-response-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Generando Respuesta...';
        loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>';
        loaderContainer.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        resultContainer.style.opacity = '0'; // Reinicia la opacidad para la animación

        const formData = {
            group_post_content: document.getElementById('group_post_content').value, // Simplificado
            user_service: document.getElementById('user_service').value,
            communication_tone: document.getElementById('communication_tone').value
        };

        try {
            const response = await fetch('api/API-Generador-De-Respuestas-Para-Grupos.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || `El servidor respondió con un error ${response.status}.`);
            }

            const data = await response.json();
            if(data.error) {
                throw new Error(data.error);
            }
            displayResult(data.group_response);

        } catch (error) {
            console.error("Error:", error);
            let errorMessage = "No se pudo generar la respuesta. Por favor, revisa los datos e inténtalo de nuevo.";

            try {
                const jsonStartIndex = error.message.indexOf('{');
                if (jsonStartIndex !== -1) {
                    const errorJsonString = error.message.substring(jsonStartIndex);
                    const errorDetails = JSON.parse(errorJsonString);
                    if (errorDetails.error && errorDetails.error.code === 503) {
                        errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                    } else {
                        errorMessage += ` Detalles: ${error.message}`;
                    }
                } else {
                    errorMessage += ` Detalles: ${error.message}`;
                }
            } catch (parseError) {
                errorMessage += ` Detalles: ${error.message}`;
            }

            resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
            resultContainer.style.opacity = '1';
        } finally {
            btnText.textContent = 'GENERAR RESPUESTA';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(group_response) {
        resultContainer.innerHTML = `
            <div class="ai-response p-6 md:p-8 rounded-xl shadow-md space-y-8">
                <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-lightbulb mr-3 text-[var(--color-primary)]"></i>Tu Respuesta Para El Grupo
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                    <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                        <h4 class="text-lg font-semibold text-gray-700 mb-3">🇪🇸 Español</h4>
                        <textarea readonly class="group-response-textarea"></textarea>
                        <button class="copy-group-response-btn bg-[var(--color-primary)] text-white px-3 py-1 rounded-md text-sm hover:opacity-90 transition-opacity" data-copy-text="${encodeURIComponent(group_response.es)}"><i class="fas fa-copy mr-1"></i>Copiar</button>
                    </div>
                    <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                        <h4 class="text-lg font-semibold text-gray-700 mb-3">🇺🇸 English</h4>
                        <textarea readonly class="group-response-textarea"></textarea>
                        <button class="copy-group-response-btn bg-[var(--color-secondary)] text-white px-3 py-1 rounded-md text-sm hover:opacity-90 transition-opacity" data-copy-text="${encodeURIComponent(group_response.en)}"><i class="fas fa-copy mr-1"></i>Copy</button>
                    </div>
                </div>
            </div>
        `;
        setTimeout(() => { resultContainer.style.opacity = '1'; resultContainer.style.transform = 'scale(1)'; }, 100);

        // Populate textareas and adjust height after they are in the DOM
        resultContainer.querySelectorAll('.group-response-textarea').forEach((textarea, i) => {
            const langKey = (i % 2 === 0) ? 'es' : 'en';
            textarea.value = group_response[langKey];
            autoResizeTextarea(textarea); // Call autoResize after setting content
        });

        resultContainer.querySelectorAll('.copy-group-response-btn').forEach(button => {
            button.addEventListener('click', function() {
                const textToCopy = decodeURIComponent(this.dataset.copyText);
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const originalContent = this.innerHTML;
                    this.innerHTML = '<i class="fas fa-check"></i> Copiado';
                    this.classList.add('copied');
                    setTimeout(() => {
                        this.innerHTML = originalContent;
                        this.classList.remove('copied');
                    }, 2000);
                }).catch(err => {
                    console.error('Error al copiar el texto: ', err);
                });
            });
        });
    }

    // Function to auto-adjust textarea height and remove scrollbars
    function autoResizeTextarea(textarea) {
        textarea.style.height = '1px'; // Reset height to a minimal value
        textarea.style.height = (textarea.scrollHeight) + 'px'; // Set to scroll height
        textarea.style.overflow = 'hidden'; // Ensure scrollbar is hidden
    }

    // Apply auto-resize to the initial form textareas
    // Simplified to only include group_post_content
    document.querySelectorAll('#group_post_content').forEach(textarea => {
        textarea.addEventListener('input', () => autoResizeTextarea(textarea));
        autoResizeTextarea(textarea); // Initial adjustment
    });

});
</script>

</body>
</html>