<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!$data) {
    http_response_code(400);
    echo json_encode(['error' => 'No se recibieron datos o el formato es incorrecto.']);
    exit;
}

// --- Validación de campos requeridos ---
$required_fields = ['campaign_objective', 'investment', 'messages', 'closed_clients', 'service_price', 'demographics', 'locations', 'platform'];
foreach ($required_fields as $field) {
    if (!isset($data[$field])) {
        http_response_code(400);
        echo json_encode(['error' => "Falta el campo requerido: {$field}"]);
        exit;
    }
}

// --- Cálculos de métricas clave en el backend ---
$investment = (float)($data['investment'] ?? 0);
$messages = (int)($data['messages'] ?? 0);
$closed_clients = (int)($data['closed_clients'] ?? 0);
$service_price = (float)($data['service_price'] ?? 0);

$cac = $closed_clients > 0 ? $investment / $closed_clients : 0;
$total_revenue = $closed_clients * $service_price;
$roi = $investment > 0 ? ($total_revenue - $investment) / $investment : 0;
$closing_rate = $messages > 0 ? ($closed_clients / $messages) * 100 : 0;

$formatted_cac = '$' . number_format($cac, 2);
$formatted_roi = number_format($roi, 2) . 'x';
$formatted_closing_rate = number_format($closing_rate, 2) . '%';

// --- Creación del PROMPT para la IA ---
$prompt = "
Actúa como un asesor de marketing digital. Tu objetivo es explicar los resultados de una campaña de Meta Ads de forma muy sencilla y clara, como si hablaras con el dueño de un negocio que no es experto en marketing.
Evita la jerga técnica como 'embudo de conversión', 'puntos de fricción', 'CTR', 'CAC', 'ROI', etc. En su lugar, explica los conceptos en términos de beneficios prácticos. Por ejemplo, en vez de 'analizar el embudo de conversión', di algo como 'revisar el proceso desde que alguien ve tu anuncio hasta que te compra, para ver si algo los detiene'.

Analiza los siguientes datos y métricas pre-calculadas de una campaña publicitaria y proporciona un diagnóstico y un plan de acción.

DATOS DE LA CAMPAÑA:
- Objetivo de la Campaña: {$data['campaign_objective']}
- Inversión Total: \${$data['investment']}
- Precio del Producto/Servicio: \${$data['service_price']}
- Mensajes o Contactos Recibidos: {$data['messages']}
- Clientes Cerrados: {$data['closed_clients']}
- Impresiones: {$data['impressions']}
- Clics: {$data['clicks']}
- Mejor Demografía: {$data['demographics']}
- Mejor Plataforma: {$data['platform']}
- Mejores Ubicaciones: {$data['locations']}

MÉTRICAS CLAVE (ya calculadas para tu análisis):
- Costo por Cliente Nuevo: {$formatted_cac}
- Retorno de Inversión: {$formatted_roi}
- Tasa de Cierre (de mensajes a clientes): {$formatted_closing_rate}

Basado en los datos y las métricas, proporciona la respuesta en el formato JSON especificado.
En el objeto 'metricas_clave' del JSON, usa los valores ya calculados que te he proporcionado. No los recalcules.
Para el 'analisis_financiero', 'diagnostico_anuncio' y 'plan_de_accion', usa un lenguaje 100% comprensible para alguien sin conocimientos de marketing.
";

$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

$payload = [
    'contents' => [['parts' => [['text' => $prompt]]]],
    'generationConfig' => [
        'response_mime_type' => 'application/json',
        'response_schema' => [
            'type' => 'OBJECT',
            'properties' => [
                'diagnostico_general' => ['type' => 'STRING'],
                'metricas_clave' => [
                    'type' => 'OBJECT',
                    'properties' => [
                        'cac' => ['type' => 'STRING'],
                        'roi' => ['type' => 'STRING'],
                        'tasa_cierre' => ['type' => 'STRING']
                    ]
                ],
                'analisis_financiero' => ['type' => 'STRING'],
                'diagnostico_anuncio' => ['type' => 'STRING'],
                'plan_de_accion' => [
                    'type' => 'ARRAY',
                    'items' => ['type' => 'STRING']
                ]
            ]
        ]
    ]
];


$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    // Devuelve el error de cURL o el cuerpo de la respuesta de la API si está disponible
    $error_details = curl_error($ch) ?: $response;
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.', 'details' => $error_details]);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? '';

// Limpiar la respuesta para asegurar que es un JSON válido
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido o corrupto.', 'raw_response' => $generated_text]);
    exit;
}

// Asegurarse de que las métricas calculadas estén en la respuesta final
$final_data['metricas_clave']['cac'] = $formatted_cac;
$final_data['metricas_clave']['roi'] = $formatted_roi;
$final_data['metricas_clave']['tasa_cierre'] = $formatted_closing_rate;

echo json_encode($final_data);
?>