<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!$data || !isset($data['customer_name']) || !isset($data['customer_comment']) || !isset($data['preferred_tone'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud (nombre del cliente, comentario o tono preferido).']);
    exit;
}

$customer_name = htmlspecialchars($data['customer_name']);
$customer_comment = htmlspecialchars($data['customer_comment']);
$preferred_tone = htmlspecialchars($data['preferred_tone']);

// Definir el tono contrastante
$contrasting_tone = '';
switch ($preferred_tone) {
    case 'Profesional':
        $contrasting_tone = 'Amigable y Entusiasta';
        break;
    case 'Amigable':
        $contrasting_tone = 'Profesional y Conciso';
        break;
    case 'Entusiasta':
        $contrasting_tone = 'Profesional y Agradecido';
        break;
    case 'Empático':
        $contrasting_tone = 'Directo y Orientado a la Acción';
        break;
    default:
        $contrasting_tone = 'Amigable'; // Fallback
        break;
}

$prompt = "Actúa como un experto en gestión de reputación online y comunicación para negocios locales. Tu tarea es generar dos propuestas de respuesta a una reseña de cliente, cada una con un tono diferente, pero ambas agradeciendo y motivando a seguir trabajando juntos.

--- CONTEXTO Y OBJETIVO ---
El objetivo es responder a las reseñas de clientes de forma profesional, cercana y que fomente la lealtad. Debes mostrar aprecio por su feedback y abrir la puerta a futuras interacciones.

--- DATOS DE LA RESEÑA ---
- Nombre del Cliente: {$customer_name}
- Comentario/Reseña: \"{$customer_comment}\"
- Tono Preferido por el Usuario para una de las respuestas: {$preferred_tone}

--- TU TAREA ESPECÍFICA ---
Genera 2 respuestas distintas a la reseña del cliente. Cada respuesta debe tener una versión completa y correcta en **español (para la clave 'es')** y otra versión completa y correcta en **inglés (para la clave 'en')**. Asegúrate de que las versiones en español sean realmente en español y las de inglés en inglés, sin mezclas.

1.  **Primera Respuesta:** Utiliza el tono **'{$preferred_tone}'**.
2.  **Segunda Respuesta:** Utiliza un tono **'{$contrasting_tone}'**.

REGLAS ESTRICTAS PARA CADA RESPUESTA:
-   **Agradecimiento:** Siempre inicia agradeciendo por la reseña.
-   **Menciona el Nombre:** Si el nombre del cliente está disponible, úsalo para personalizar (ej. \"Gracias, {$customer_name}!\").
-   **Referencia al Comentario:** Haz una breve referencia al contenido específico de su reseña para mostrar que leíste y valoras su opinión.
-   **Invitación a Futuras Interacciones:** Concluye motivando al cliente a seguir trabajando juntos o a volver a visitarte.
-   **Brevedad:** Cada respuesta debe ser concisa, ideal para redes sociales o plataformas de reseñas (máximo 4-5 frases).
-   **No pidas datos personales ni menciones precios.**

--- FORMATO DE RESPUESTA REQUERIDO ---
La respuesta DEBE ser un objeto JSON válido con una clave 'responses', que es un array de 2 objetos. Cada objeto en 'responses' debe tener:
- 'tone': string (ej. \"Profesional\")
- 'es': string (respuesta en español)
- 'en': string (respuesta en inglés)
";

$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response' => $response
    ]);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? null;

if ($generated_text) {
    $generated_text = str_replace(['```json', '```'], '', $generated_text);
}

$final_data = json_decode(trim($generated_text), true);

if ($final_data === null || !isset($final_data['responses']) || !is_array($final_data['responses']) || count($final_data['responses']) !== 2) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o incompleto. Intenta de nuevo con tus datos.',
        'raw_ai_response_after_trim' => trim($generated_text),
        'decoded_data_debug' => $final_data
    ]);
    exit;
}

echo json_encode($final_data);
?>