<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

// Obtener y decodificar los datos JSON de la solicitud
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que los datos requeridos estén presentes
if (!$data || !isset($data['situations']) || empty($data['situations'])) {
    http_response_code(400);
    echo json_encode(['error' => 'No se seleccionó ninguna situación. Por favor, selecciona al menos una opción para generar el diagnóstico.']);
    exit;
}

$situations_list = implode("\n- ", $data['situations']);

// --- PROMPT MAESTRO (v1.1 - CON CONTEXTO DEL CURSO) ---
$prompt = "Actúa como un coach de negocios y mentor del curso 'CLIENT3'. Tu objetivo es analizar la situación actual de un estudiante y darle un diagnóstico claro y un plan de acción motivador, basado ESTRICTAMENTE en la filosofía y módulos del curso.

--- FILOSOFÍA Y ESTRUCTURA DEL CURSO CLIENT3 ---
1.  *La Base (ANTES):* Todo empieza con los cimientos.
    - *Módulo 1: Prepara Tu Página:* Se optimiza la página de Facebook para que luzca profesional y confiable.
    - *Módulo 2: ¿Quién Es Tu Mejor Cliente Potencial?:* Se define al cliente ideal (su perfil, problema y deseo emocional). Este es el paso más importante.
2.  *El Mensaje (ANTES):*
    - *Módulo 3: Creando El Anuncio Estratégico:* Se crea el anuncio perfecto con un visual potente y un texto persuasivo (Gancho, Solución, CTA).
3.  *La Acción (DURANTE):*
    - *Módulo 4: Lanzando Tu Campaña:* Se aprieta el botón 'Promocionar' de forma inteligente, eligiendo el objetivo 'Recibir Mensajes', el público y presupuesto correctos.
4.  *El Análisis (DESPUÉS):*
    - *Módulo 5: ¿Funcionó?:* Se analizan las 2 métricas clave (Conversaciones y Costo por Conversación) para mejorar.
5.  *Herramientas de Apoyo:* El curso incluye un Centro de Herramientas IA para ejecutar cada paso (Asistente de Cliente Ideal, Asistente de Anuncios, etc.).

--- TU TAREA ESPECÍFICA ---
Un estudiante ha seleccionado las siguientes situaciones que describen su negocio:
- {$situations_list}

Analiza estas selecciones y realiza 3 cosas:
1.  **Asigna una 'Puntuación de Preparación' del 1 al 10:** Una puntuación BAJA (1-4) significa que necesita empezar desde los fundamentos. Una MEDIA (5-7) que ya ha intentado cosas pero sin estrategia. Una ALTA (8-10) que solo necesita optimizar.
2.  **Escribe un 'Diagnóstico General':** Un párrafo corto y alentador que resuma su situación.
3.  **Crea un 'Plan de Acción Personalizado':** Un array de 2 o 3 strings. Cada paso debe ser claro y accionable, recomendando qué MÓDULO específico del curso (de los mencionados arriba) debe repasar o qué HERRAMIENTA del ecosistema CLIENT3 debe usar primero. LAS RECOMENDACIONES DEBEN SER 100% COHERENTES CON EL CONTENIDO DEL CURSO DESCRITO.

--- FORMATO DE RESPUESTA REQUERIDO ---
La respuesta DEBE ser un objeto JSON válido con la siguiente estructura: 'puntuacion', 'diagnostico_general', 'plan_de_accion'.";

// URL de la API de Google Gemini
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

// Inicializar cURL
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Devuelve la respuesta como string en lugar de imprimirla
curl_setopt($ch, CURLOPT_POST, true);           // Método POST
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload)); // Datos a enviar en formato JSON
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']); // Cabecera Content-Type

// Ejecutar la solicitud cURL y obtener la respuesta
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Obtener el código HTTP
$curl_error = curl_error($ch); // Obtener cualquier error de cURL
curl_close($ch); // Cerrar la sesión cURL

// Manejo de errores de la solicitud cURL o respuesta HTTP
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response' => $response // Incluir respuesta cruda para depuración
    ]);
    exit;
}

// Decodificar la respuesta de la IA
$result = json_decode($response, true);

// Extraer el texto generado. Esto asume una estructura específica de la respuesta de la API de Gemini.
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? null;

// Limpiar el texto de posibles bloques de código Markdown
if ($generated_text) {
    $generated_text = str_replace(['```json', '```'], '', $generated_text);
}

// Intentar decodificar el JSON final.
$final_data = json_decode(trim($generated_text), true);

// Validar el formato del JSON final
if ($final_data === null) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o la respuesta estaba vacía.',
        'raw_ai_response_after_trim' => trim($generated_text) // Mostrar lo que se intentó decodificar
    ]);
    exit;
}

// Validar que la estructura esperada esté presente (ej. 'puntuacion' es una clave raíz esperada)
if (!isset($final_data['puntuacion']) || !isset($final_data['diagnostico_general']) || !isset($final_data['plan_de_accion'])) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA no devolvió la estructura de datos esperada (falta puntuacion, diagnostico_general, o plan_de_accion).',
        'generated_data' => $final_data // Mostrar los datos parciales recibidos de la IA
    ]);
    exit;
}

// Si todo es correcto, devolver los datos generados
echo json_encode($final_data);
?>